/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.DataBlock;
import com.sun.jade.device.fcswitch.ancor.sanbox.VariableDefinition;
import com.sun.jade.util.unittest.UnitTest;
import java.util.Random;

public class SanboxHeader {
    public static final int MAX_MSG_SIZE = 512;
    public static final int MSG_HDR_SIZE = 16;
    public static final int CHECKSUM_SIZE = 4;
    public static final int VERSION_NUM = 4352;
    public static final String VERSION = "hdr_versionHdr";
    public static final String FLAGS = "hdr_flags";
    public static final String STAGE_TYPES = "hdr_stageTypes";
    public static final String DEST_ADDR = "hdr_destAddr";
    public static final String COMMAND = "hdr_command";
    public static final String LENGTH = "hdr_length";
    public static final String SEQ_NUM = "hdr_seqNum";
    public static final String CHECKSUM = "chksum";
    static long seqNum = new Random().nextLong();
    protected DataBlock block;
    static VariableDefinition[] ancor_hdr = new VariableDefinition[]{new VariableDefinition("hdr_versionHdr", 2), new VariableDefinition("hdr_flags", 2), new VariableDefinition("hdr_stageTypes", 1), new VariableDefinition("hdr_destAddr", 3), new VariableDefinition("hdr_command", 2), new VariableDefinition("hdr_length", 2), new VariableDefinition("hdr_seqNum", 4)};
    static VariableDefinition[] checksum = new VariableDefinition[]{new VariableDefinition("chksum", 4)};
    private static final String sccs_id = "@(#)SanboxHeader.java\t1.7 04/04/02 SMI";

    public SanboxHeader(int n) {
        this.block = new DataBlock(ancor_hdr, checksum);
        this.block.setVariable(VERSION, 4352L);
        this.block.setVariable(DEST_ADDR, 0xFFFFFDL);
        this.block.setVariable(COMMAND, n);
        this.block.setVariable(LENGTH, this.block.getBlockSize() - 16);
        this.block.setVariable(SEQ_NUM, seqNum++);
    }

    public SanboxHeader(VariableDefinition[] variableDefinitionArray) {
        this.block = new DataBlock(ancor_hdr.length + variableDefinitionArray.length + checksum.length);
        this.block.setDefinition(ancor_hdr, 0);
        this.block.setDefinition(variableDefinitionArray, ancor_hdr.length);
        this.block.setDefinition(checksum[0], ancor_hdr.length + variableDefinitionArray.length);
        this.block.setUpDataBlock();
        this.block.setVariable(VERSION, 4352L);
        this.block.setVariable(DEST_ADDR, 0xFFFFFDL);
        this.block.setVariable(LENGTH, this.block.getBlockSize() - 16);
        this.block.setVariable(SEQ_NUM, seqNum++);
    }

    public SanboxHeader(byte[] byArray) {
        this.block = new DataBlock(ancor_hdr);
        this.block.useData(byArray);
    }

    public byte[] getBytes() {
        this.setChecksum();
        return this.block.getBlockData();
    }

    public static VariableDefinition[] getStructure() {
        return ancor_hdr;
    }

    public DataBlock getBlock() {
        return this.block;
    }

    public void useData(byte[] byArray) {
        this.block.useData(byArray);
    }

    public int getVersion() {
        return (int)this.block.getVariableValue(VERSION);
    }

    public int getLength() {
        return (int)this.block.getVariableValue(LENGTH);
    }

    public long getSequenceNumber() {
        return this.block.getVariableValue(SEQ_NUM);
    }

    public void setCommand(int n) {
        this.block.setVariable(COMMAND, n);
    }

    public int getCommand() {
        return (int)this.block.getVariableValue(COMMAND);
    }

    public void setDestinationAddress(int n) {
        this.block.setVariable(DEST_ADDR, n);
    }

    public int getDestinationAddress() {
        return (int)this.block.getVariableValue(DEST_ADDR);
    }

    public void setChecksum() {
        this.block.setVariable(CHECKSUM, 0L);
        long l = this.block.getCheckSum();
        this.block.setVariable(CHECKSUM, l);
    }

    public static class Test
    extends UnitTest {
        public void test() {
            byte[] byArray = new byte[100];
            int n = 0;
            while (n < 100) {
                byArray[n] = (byte)n;
                ++n;
            }
            SanboxHeader sanboxHeader = new SanboxHeader(byArray);
            this.assertNotNull(sanboxHeader);
            sanboxHeader = new SanboxHeader(1);
            this.assertCondition(sanboxHeader.getCommand() == 1);
            this.assertCondition(sanboxHeader.getLength() == 4);
            this.assertCondition(sanboxHeader.getDestinationAddress() == 0xFFFFFD);
            this.assertCondition(sanboxHeader.getVersion() == 4352);
        }
    }
}

