/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.PortCounts;
import com.sun.jade.device.fcswitch.ancor.sanbox.Sanbox;
import com.sun.jade.device.fcswitch.ancor.sanbox.TestStatus;
import com.sun.jade.util.unittest.UnitTest;
import java.net.InetAddress;

public class SwitchMonitor {
    static long OLDfcFPortSyncLosses = 0L;
    static long OLDfcFPortInvalidTxWords = 0L;
    static long OLDfcFPortInvalidCrcs = 0L;
    static long OLDfcFPortDelimiterErrors = 0L;
    static long OLDfcFPortAddressIdErrors = 0L;
    static long OLDfcFPortLinkResetIns = 0L;
    static long OLDtotal_lip_rcvd_cnt = 0L;
    static long OLDal_init_err_cnt = 0L;
    static long OLDal_init_attempts_cnt = 0L;
    static long OLDshort_frame_err_cnt = 0L;
    static long OLDlong_frame_err_cnt = 0L;
    static long OLDloss_of_signal_cnt = 0L;
    static long OLDlaser_fault_cnt = 0L;
    static long OLDloop_init_failed = 0L;
    static long fcFPortSyncLosses = 0L;
    static long fcFPortInvalidTxWords = 0L;
    static long fcFPortInvalidCrcs = 0L;
    static long fcFPortDelimiterErrors = 0L;
    static long fcFPortAddressIdErrors = 0L;
    static long fcFPortLinkResetIns = 0L;
    static long total_lip_rcvd_cnt = 0L;
    static long al_init_err_cnt = 0L;
    static long al_init_attempts_cnt = 0L;
    static long short_frame_err_cnt = 0L;
    static long long_frame_err_cnt = 0L;
    static long loss_of_signal_cnt = 0L;
    static long laser_fault_cnt = 0L;
    static long loop_init_failed = 0L;
    static Thread thread = Thread.currentThread();
    public static boolean debug = true;
    public static final int ERROR = -1;

    public static void usage(int n) {
        SwitchMonitor.usage();
        System.exit(n);
    }

    public static void usage() {
        System.out.println("Usage: ");
        System.out.println("version        <ip-address>");
        System.out.println("start_test     <ip-address> <port> [ size length pattern ]");
        System.out.println("test_status    <ip-address> <port>");
        System.out.println("stop_test      <ip-address> <port>");
        System.out.println("port_counts    <ip-address> <port>");
        System.out.println("initiators     <ip-address>");
        System.out.println("chassis_status <ip-address>");
    }

    public static long oldPortCounts(PortCounts portCounts) {
        return 0L;
    }

    public static void run(String[] stringArray) throws Exception {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        long l3 = 1000000L;
        long l4 = 0L;
        InetAddress inetAddress = InetAddress.getByName(stringArray[0]);
        Sanbox sanbox = new Sanbox(inetAddress);
        System.out.println("IP:     " + sanbox.getHost().getHostAddress());
        while (l2 < l3 && n < 60) {
            Integer n2 = new Integer(stringArray[1]);
            int n3 = n2;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TestStatus testStatus = sanbox.getTestStatus();
            System.out.println("--------------port=" + n3);
            System.out.println("test_fail_cnt:          " + testStatus.getTestFailCount());
            l4 = testStatus.getPortTestStatus(--n3);
            System.out.println(testStatus.getBlock());
            System.out.println("port_test_status:       " + l4);
            l2 += testStatus.getPortTestCount(n3);
            System.out.println("port_test_count:        " + testStatus.getPortTestCount(n3));
            System.out.println("port_fail_count:        " + testStatus.getPortFailCount(n3));
            if (l4 != 1L) {
                System.out.println("ERROR");
                System.exit(-1);
            }
            System.out.println("llong=" + l2 + " num_loops=" + n);
            PortCounts portCounts = sanbox.getPortCounts(n3);
            System.out.println(portCounts.getBlock());
            if (++n == 0) {
                OLDfcFPortSyncLosses = portCounts.getfcFPortSyncLosses();
                OLDfcFPortInvalidTxWords = portCounts.getfcFPortInvalidTxWords();
                OLDfcFPortInvalidCrcs = portCounts.getfcFPortInvalidCrcs();
                OLDfcFPortDelimiterErrors = portCounts.getfcFPortDelimiterErrors();
                OLDfcFPortAddressIdErrors = portCounts.getfcFPortAddressIdErrors();
                OLDfcFPortLinkResetIns = portCounts.getfcFPortLinkResetIns();
                OLDtotal_lip_rcvd_cnt = portCounts.gettotal_lip_rcvd_cnt();
                OLDal_init_err_cnt = portCounts.getal_init_err_cnt();
                OLDal_init_attempts_cnt = portCounts.getal_init_attempts_cnt();
                OLDshort_frame_err_cnt = portCounts.getshort_frame_err_cnt();
                OLDlong_frame_err_cnt = portCounts.getlong_frame_err_cnt();
                OLDloss_of_signal_cnt = portCounts.getloss_of_signal_cnt();
                OLDlaser_fault_cnt = portCounts.getlaser_fault_cnt();
                OLDloop_init_failed = portCounts.getloop_init_failed();
            } else {
                fcFPortSyncLosses = portCounts.getfcFPortSyncLosses();
                fcFPortInvalidTxWords = portCounts.getfcFPortInvalidTxWords();
                fcFPortInvalidCrcs = portCounts.getfcFPortInvalidCrcs();
                fcFPortDelimiterErrors = portCounts.getfcFPortDelimiterErrors();
                fcFPortAddressIdErrors = portCounts.getfcFPortAddressIdErrors();
                fcFPortLinkResetIns = portCounts.getfcFPortLinkResetIns();
                total_lip_rcvd_cnt = portCounts.gettotal_lip_rcvd_cnt();
                al_init_err_cnt = portCounts.getal_init_err_cnt();
                al_init_attempts_cnt = portCounts.getal_init_attempts_cnt();
                short_frame_err_cnt = portCounts.getshort_frame_err_cnt();
                long_frame_err_cnt = portCounts.getlong_frame_err_cnt();
                loss_of_signal_cnt = portCounts.getloss_of_signal_cnt();
                laser_fault_cnt = portCounts.getlaser_fault_cnt();
                loop_init_failed = portCounts.getloop_init_failed();
            }
            System.out.println("OLDfcFPortInvalidTxWords=" + OLDfcFPortInvalidTxWords);
            System.out.println("   fcFPortInvalidTxWords=" + fcFPortInvalidTxWords);
        }
    }

    public static void main(String[] stringArray) {
        block3: {
            if (stringArray.length < 1) {
                SwitchMonitor.usage();
                System.exit(1);
            }
            try {
                SwitchMonitor.run(stringArray);
            }
            catch (Exception exception) {
                System.out.println("Error " + exception);
                if (!debug) break block3;
                exception.printStackTrace();
            }
        }
    }

    public static class Test
    extends UnitTest {
        public void test() {
            SwitchMonitor switchMonitor = new SwitchMonitor();
            this.assertNotNull(switchMonitor);
        }
    }
}

