/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.io;

import com.sun.jade.device.fcswitch.ancor.sanbox.Sanbox;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxException;
import com.sun.jade.device.fcswitch.util.snmp.CIMStateStatusHelper;
import com.sun.jade.device.fcswitch.util.snmp.FA_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.PortSpeedHelper;
import com.sun.jade.device.fcswitch.util.snmp.SNMPPortType;
import com.sun.jade.device.fcswitch.util.snmp.SNMPToCIM_State_Status;
import com.sun.jade.device.fcswitch.util.snmp.SNMPToString_State_Status;
import com.sun.jade.device.fcswitch.util.snmp.SNMPWalk;
import com.sun.jade.device.fcswitch.util.snmp.SwitchWWNsnmp;
import com.sun.jade.device.fcswitch.util.zones.Zones;
import com.sun.jade.device.protocol.snmp.SingleSnmpSession;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.snmp.SnmpStatusException;

public class SwitchDeviceReport
implements ReportGenerator {
    private Properties props;
    private static final String CIM_VERSION = "CIM 2.5";
    private String ip;
    private int portCount;
    private String wwn;
    private HashMap systemProps = null;
    private HashMap portStatProps = null;
    private HashMap portProps = null;
    private HashMap revisionProps = null;
    private HashMap sensorProps = null;
    private HashMap systemUnitProps = null;
    private SwitchWWNsnmp swSnmp = null;
    private HashMap portResult = null;
    private static final String SYSTEM_VIEW = "SystemView";
    private static final String ZONE_VIEW = "ZoneView";
    private static final String NUMBER_OF_PORTS = "connUnitNumports";
    private static final String CONNECTED_PORT_NUMBER = "connUnitLinkPortNumberX";
    private static final String DOT = ".";
    private static final String PORT_COUNT_ERROR_MESSAGE = "Error getting the number of ports.";
    private static final String SENSOR_COUNT_ERROR_MESSAGE = "Error getting the number of sensors.";
    private static final int TEN = 10;
    private static final String LOG_TAG = "Switch_Device_Report";
    private static final String DEFAULT_PORT_TYPE = "1";
    private static final String SENSOR_TYPE_FAN = "4";
    private static final String SENSOR_TYPE_TEMPERATURE = "8";
    private static final String SWITCH1GB_SENSOR_TYPE_TEMPERATURE = "2";
    private static final String SENSOR_TYPE_POWER = "5";
    private FA_Mibsnmp switchsnmp = null;
    private int noOfZones;
    private int noOfSensors;
    private Zones[] zones = null;
    private Sanbox sanbox = null;
    public static final String sccs_id = "@(#)SwitchDeviceReport.java\t1.32 04/07/03 SMI";

    public SwitchDeviceReport(Properties properties) {
        this.props = properties;
        this.ip = properties.getProperty("ip");
        this.wwn = properties.getProperty("wwn");
        try {
            this.portCount = Integer.parseInt(properties.getProperty("NumberOfPorts"));
            this.noOfSensors = Integer.parseInt(properties.getProperty("NumberOfSensors"));
        }
        catch (Exception exception) {
            this.portCount = 0;
            this.noOfSensors = 0;
        }
        this.switchsnmp = new FA_Mibsnmp(this.props);
        this.sanbox = new Sanbox(this.ip);
    }

    public synchronized String generateReport() {
        DeviceClass deviceClass = null;
        DeviceClass deviceClass2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        DeviceClass deviceClass3 = null;
        DeviceClass deviceClass4 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        String string = null;
        try {
            string = this.switchsnmp.resolveVarName(CONNECTED_PORT_NUMBER).getOid();
        }
        catch (SnmpStatusException snmpStatusException) {
            // empty catch block
        }
        this.systemProps = this.switchsnmp.getConnectivityProps();
        if (this.portCount == 0) {
            this.portCount = this.getNumberOfPorts();
        }
        DeviceClass deviceClass5 = this.getReport();
        DeviceClass deviceClass6 = deviceClass5.newSubInstance();
        deviceClass6.setClassName("model");
        deviceClass6.setProperty("schema", CIM_VERSION);
        deviceClass6.setProperty("view", "system");
        deviceClass6.setProperty("type", "switch");
        deviceClass6.setProperty("prefix", "StorAdeSwitch");
        deviceClass6.setProperty("package", "com.sun.jade.cim.bean");
        Report.debug.log(LOG_TAG, (Object)("Filter " + string + DOT + this.props.getProperty("wwnSnmp")));
        this.discoverConnectedDevice(string + DOT + this.props.getProperty("wwnSnmp"));
        DeviceClass deviceClass7 = deviceClass6.newSubInstance();
        deviceClass7.setClassName(SYSTEM_VIEW);
        DeviceClass deviceClass8 = deviceClass7.newSubInstance();
        this.populateSwitchSystem(this.switchsnmp, deviceClass8);
        DeviceClass deviceClass9 = deviceClass8.newSubInstance();
        this.populateChassisDevice(this.switchsnmp, deviceClass9);
        DeviceClass deviceClass10 = deviceClass8.newSubInstance();
        this.populatePhysicalPackage(this.switchsnmp, deviceClass10);
        if (this.portCount != 0) {
            int n = 1;
            while (n <= this.portCount) {
                this.portStatProps = this.switchsnmp.getPortStatProps(n);
                this.portProps = this.switchsnmp.getPortProps(n);
                deviceClass2 = deviceClass8.newSubInstance();
                this.populateFibrePort(this.switchsnmp, deviceClass2, n);
                deviceClass = deviceClass2.newSubInstance();
                this.populateFibreCounters(this.switchsnmp, deviceClass, n);
                deviceClass3 = deviceClass2.newSubInstance();
                this.populateProtocolEndPoint(this.switchsnmp, deviceClass3, n);
                Set set = this.portResult.entrySet();
                Iterator iterator = set.iterator();
                String string2 = null;
                int n2 = 0;
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string3 = (String)entry.getValue();
                    try {
                        n2 = Integer.parseInt(string3, 10);
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    if (n2 + 1 != n) continue;
                    deviceClass4 = deviceClass3.newSubInstance();
                    string2 = (String)entry.getKey();
                    int n3 = string2.lastIndexOf(DOT);
                    string2 = string2.substring(n3);
                    HashMap hashMap = this.switchsnmp.getLinkProps(string2);
                    deviceClass4.setClassName("ProtocolEndpoint");
                    String string4 = (String)hashMap.get("connUnitLinkPortWwnY");
                    if (string4 != null) {
                        string4 = string4.substring(0, 16);
                    }
                    deviceClass4.setProperty("Name", string4);
                    deviceClass4.setProperty("NameFormat", "WWN");
                    deviceClass4.setProperty("ProtocolType", "Fibre Channel");
                }
                ++n;
            }
        }
        return deviceClass5.toXML();
    }

    protected String getIP() {
        return this.ip;
    }

    protected String getWWN() {
        return this.wwn;
    }

    protected String getPortWWN(int n) {
        String string = (String)this.portProps.get("connUnitPortWwn");
        if (string == null) {
            String string2 = Integer.toHexString(n);
            string = this.computePortWWN(string2);
        }
        return string;
    }

    private String computePortWWN(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.getWWN());
        stringBuffer.setCharAt(0, '2');
        if (string.length() > 1) {
            stringBuffer.setCharAt(2, string.charAt(0));
            stringBuffer.setCharAt(3, string.charAt(1));
            return stringBuffer.toString();
        }
        stringBuffer.setCharAt(3, string.charAt(0));
        return stringBuffer.toString();
    }

    protected void populateProtocolEndPoint(FA_Mibsnmp fA_Mibsnmp, DeviceClass deviceClass, int n) {
        String string = null;
        deviceClass.setClassName("ProtocolEndpoint");
        string = this.getPortWWN(n - 1);
        string = string.substring(0, 16);
        deviceClass.setProperty("Name", string == null ? "" : string);
        deviceClass.setProperty("NameFormat", "WWN");
        deviceClass.setProperty("ProtocolType", "Fibre Channel");
    }

    protected void discoverConnectedDevice(String string) {
        SNMPWalk sNMPWalk = new SNMPWalk(this.ip);
        HashMap hashMap = new HashMap();
        hashMap = sNMPWalk.getProperties(CONNECTED_PORT_NUMBER, "connUnitLinkPortWwnX");
        this.portResult = sNMPWalk.filterProperties(hashMap, string);
    }

    protected void populateSwitchSystem(FA_Mibsnmp fA_Mibsnmp, DeviceClass deviceClass) {
        Object var3_3 = null;
        deviceClass.setClassName("UnitaryComputerSystem");
        deviceClass.setProperty("Name", this.getWWN());
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString((String)this.systemProps.get("connUnitStatus"))));
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("OtherIdentifyingInfo", this.ip);
        deviceClass.setProperty("IdentifyingDescriptions", "'IP Address'");
        deviceClass.setProperty("PortCount", (String)this.systemProps.get(NUMBER_OF_PORTS));
        this.revisionProps = fA_Mibsnmp.getRevisionProps(4);
        deviceClass.setProperty("Flash", this.revisionProps.get("connUnitRevsRevId") == null ? "-" : (String)this.revisionProps.get("connUnitRevsRevId"));
        this.revisionProps = fA_Mibsnmp.getRevisionProps(2);
        String string = (String)this.revisionProps.get("connUnitRevsRevId");
        if ("<Unknown>".equalsIgnoreCase(string)) {
            string = "UnKnown";
        }
        deviceClass.setProperty("HW", string == null ? "-" : string);
        deviceClass.setProperty("MAC", "-");
        this.revisionProps = fA_Mibsnmp.getRevisionProps(3);
        string = (String)this.revisionProps.get("connUnitRevsRevId");
        deviceClass.setProperty("PROM", string == null ? "-" : string);
        deviceClass.setProperty("WWN", this.getWWN());
        deviceClass.setProperty("ZoneTotal", this.noOfZones + "");
    }

    protected void populateFibreCounters(FA_Mibsnmp fA_Mibsnmp, DeviceClass deviceClass, int n) {
        String string = null;
        deviceClass.setClassName("DeviceStatisticalInformation");
        deviceClass.setProperty("SystemName", this.getWWN());
        deviceClass.setProperty("DeviceCreationClassName", "StorAdeSwitch_FibrePort");
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_FibrePortEventCounters");
        deviceClass.setProperty("DeviceID", "" + (n - 1));
        string = this.getPortWWN(n - 1);
        string = string == null ? "" : string;
        deviceClass.setProperty("Name", string);
        string = (String)this.portStatProps.get("connUnitPortStatCountLinkFailures");
        deviceClass.setProperty("LinkFails", string == null ? "0" : string);
        string = (String)this.portStatProps.get("connUnitPortStatCountPrimitiveSequenceProtocolErrors");
        deviceClass.setProperty("Prim_Seq_Errs", string == null ? "0" : string);
    }

    protected void populateFibrePort(FA_Mibsnmp fA_Mibsnmp, DeviceClass deviceClass, int n) {
        String string = null;
        deviceClass.setClassName("FibrePort");
        deviceClass.setProperty("SystemName", this.getWWN());
        deviceClass.setProperty("REF", "" + (n - 1));
        deviceClass.setProperty("DeviceID", "" + (n - 1));
        string = this.getPortWWN(n - 1);
        string = string == null ? "" : string;
        deviceClass.setProperty("Name", string);
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_FibrePort");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStateString((String)this.portProps.get("connUnitPortState"))));
        deviceClass.setProperty("Availability", CIMStateStatusHelper.convertToCIMAvailability(SNMPToCIM_State_Status.getOperationalStateString((String)this.portProps.get("connUnitPortState"))));
        deviceClass.setProperty("PowerManagementSupported", "false");
        string = (String)this.portStatProps.get("connUnitPortStatCountLossofSignal");
        deviceClass.setProperty("LossOfSignalCounter", string == null ? "0" : string);
        string = (String)this.portStatProps.get("connUnitPortStatCountLossofSynchronization");
        deviceClass.setProperty("LossOfSyncCounter", string == null ? "0" : string);
        string = (String)this.portStatProps.get("connUnitPortStatCountInvalidCRC");
        deviceClass.setProperty("CRCErrors", string == null ? "0" : string);
        string = (String)this.portStatProps.get("connUnitPortStatCountInvalidTxWords");
        deviceClass.setProperty("InvalidTransmissionWords", string == null ? "0" : string);
        string = (String)this.portStatProps.get("connUnitPortStatCountFramesTruncated");
        deviceClass.setProperty("FramesTooShort", string == null ? "0" : string);
        string = (String)this.portStatProps.get("connUnitPortStatCountFramesTooLong");
        deviceClass.setProperty("FramesTooLong", string == null ? "0" : string);
        string = (String)this.portProps.get("connUnitPortType");
        deviceClass.setProperty("Type", string == null ? SNMPPortType.getPortTypeString(DEFAULT_PORT_TYPE) : SNMPPortType.getPortTypeString(string));
        deviceClass.setProperty("Description", string == null ? SNMPPortType.getPortTypeString(DEFAULT_PORT_TYPE) : SNMPPortType.getPortTypeString(string));
        string = (String)this.portProps.get("connUnitPortSpeed");
        deviceClass.setProperty("Speed", string == null ? "0" : string);
        deviceClass.setProperty("PortOperatingSpeed", PortSpeedHelper.getPortSpeed(string));
        deviceClass.setProperty("OperatingStatus", SNMPToString_State_Status.getOperationalStateString((String)this.portProps.get("connUnitPortState")));
        try {
            string = this.sanbox.getPortState(n - 1).getAdministrativeStateString();
            deviceClass.setProperty("AdministrativeStatus", string == null ? "Unknown" : string);
        }
        catch (SanboxException sanboxException) {
            // empty catch block
        }
    }

    protected void populateChassisDevice(FA_Mibsnmp fA_Mibsnmp, DeviceClass deviceClass) {
        String string = null;
        deviceClass.setClassName("LogicalDevice");
        deviceClass.setProperty("SystemName", this.getWWN());
        deviceClass.setProperty("DeviceID", "Chassis");
        deviceClass.setProperty("Name", "chassis");
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_ChassisDevice");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString((String)this.systemProps.get("connUnitStatus"))));
        deviceClass.setProperty("Availability", CIMStateStatusHelper.convertToCIMAvailability(SNMPToCIM_State_Status.getOperationalStateString((String)this.systemProps.get("connUnitState"))));
        deviceClass.setProperty("Description", "Switch Chassis");
        deviceClass.setProperty("PowerManagementSupported", "false");
        deviceClass.setProperty("PowerOnSeconds", fA_Mibsnmp.getSystemUpTime() + "");
        string = fA_Mibsnmp.getSystemUpTimeString();
        deviceClass.setProperty("PowerOnTime", string == null ? "-" : string);
        if (this.noOfSensors == 0) {
            this.noOfSensors = this.getNumberOfSensors();
        }
        Report.debug.log(LOG_TAG, (Object)("Number of Sensors " + this.noOfSensors));
        int n = 1;
        while (n <= this.noOfSensors) {
            DeviceClass deviceClass2;
            this.sensorProps = fA_Mibsnmp.getSensorProps(n);
            String string2 = (String)this.sensorProps.get("connUnitSensorType");
            if (SENSOR_TYPE_TEMPERATURE.equalsIgnoreCase(string2) || SWITCH1GB_SENSOR_TYPE_TEMPERATURE.equalsIgnoreCase(string2)) {
                deviceClass2 = deviceClass.newSubInstance();
                deviceClass2.setClassName("TemperatureSensor");
                deviceClass2.setProperty("SystemName", this.wwn);
                deviceClass2.setProperty("DeviceID", (String)this.sensorProps.get("connUnitSensorName"));
                deviceClass2.setProperty("Name", (String)this.sensorProps.get("connUnitSensorName"));
                deviceClass2.setProperty("CreationClassName", "CIM_TemperatureSensor");
                deviceClass2.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
                string = (String)this.sensorProps.get("connUnitSensorMessage");
                deviceClass2.setProperty("SensorType", DEFAULT_PORT_TYPE);
                deviceClass2.setProperty("OtherSensorTypeDescription", string == null ? "Unknown" : string);
                deviceClass2.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString((String)this.sensorProps.get("connUnitSensorStatus"))));
            }
            if (SENSOR_TYPE_FAN.equalsIgnoreCase(string2)) {
                deviceClass2 = deviceClass.newSubInstance();
                deviceClass2.setClassName("Fan");
                deviceClass2.setProperty("SystemName", this.wwn);
                deviceClass2.setProperty("DeviceID", (String)this.sensorProps.get("connUnitSensorName"));
                deviceClass2.setProperty("Name", (String)this.sensorProps.get("connUnitSensorName"));
                deviceClass2.setProperty("CreationClassName", "CIM_Fan");
                deviceClass2.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
                deviceClass2.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString((String)this.sensorProps.get("connUnitSensorStatus"))));
            }
            if (SENSOR_TYPE_POWER.equalsIgnoreCase(string2)) {
                deviceClass2 = deviceClass.newSubInstance();
                deviceClass2.setClassName("PowerSupply");
                deviceClass2.setProperty("SystemName", this.wwn);
                deviceClass2.setProperty("DeviceID", (String)this.sensorProps.get("connUnitSensorName"));
                deviceClass2.setProperty("Name", (String)this.sensorProps.get("connUnitSensorName"));
                deviceClass2.setProperty("CreationClassName", "CIM_UninterruptiblePowerSupply");
                deviceClass2.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
                deviceClass2.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString((String)this.sensorProps.get("connUnitSensorStatus"))));
            }
            ++n;
        }
    }

    protected void populatePhysicalPackage(FA_Mibsnmp fA_Mibsnmp, DeviceClass deviceClass) {
        deviceClass.setClassName("PhysicalPackage");
        deviceClass.setProperty("Tag", this.getWWN());
        deviceClass.setProperty("Name", (String)this.systemProps.get("connUnitProduct"));
        String string = this.props.getProperty("DeviceDisplayModel");
        deviceClass.setProperty("Manufacturer", string == null ? "Sun StorEdge network FC 2Gig switch" : string);
        string = (String)this.systemProps.get("connUnitSn");
        deviceClass.setProperty("SerialNumber", string == null ? "-" : string);
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_PhysicalPackage");
        deviceClass.setProperty("Removable", "true");
        deviceClass.setProperty("Replaceable", "true");
        deviceClass.setProperty("HotSwappable", "true");
    }

    protected DeviceClass getReport() {
        DeviceClass deviceClass = new DeviceClass();
        deviceClass.setClassName("report");
        deviceClass.setProperty("ReturnCode", "OK");
        return deviceClass;
    }

    protected String getReportError(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<report ReturnCode='FAILURE'>\n");
        stringBuffer.append("<exception Reason='Lost Comm'>");
        stringBuffer.append(exception.toString());
        stringBuffer.append("</exception>\n");
        stringBuffer.append("</report>\n");
        return stringBuffer.toString();
    }

    protected void populateZones(DeviceClass deviceClass, Zones zones) {
        deviceClass.setClassName("Zone");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("REF", zones.getZoneName().trim());
        deviceClass.setProperty("Name", zones.getZoneName().trim() + " (" + zones.getZoneDescription() + ")");
        deviceClass.setProperty("ElementName", zones.getZoneName());
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("OtherZoneTypeDescription", zones.getZoneDescription());
        deviceClass.setProperty("Active", "true");
        deviceClass.setProperty("ProtocolType", DEFAULT_PORT_TYPE);
    }

    protected void populateZoneMember(DeviceClass deviceClass, Zones zones) {
        Object[] objectArray = zones.getPortList();
        if (objectArray.length > 0) {
            DeviceClass deviceClass2 = deviceClass.newSubInstance();
            deviceClass2.setClassName("ZoneMember");
            deviceClass2.setProperty("ZoneMemberType", SENSOR_TYPE_POWER);
            DeviceClass deviceClass3 = deviceClass2.newSubInstance();
            deviceClass3.setClassName("Collection");
            deviceClass3.setProperty("REF", zones.getZoneName().trim());
            int n = 0;
            while (n < objectArray.length) {
                DeviceClass deviceClass4 = deviceClass2.newSubInstance();
                deviceClass4.setClassName("Member");
                deviceClass4.setProperty("REF", ((String)objectArray[n]).trim());
                ++n;
            }
        }
    }

    private int getNumberOfPorts() {
        int n = 0;
        if (this.systemProps == null) {
            this.systemProps = this.switchsnmp.getConnectivityProps();
        }
        try {
            n = Integer.parseInt((String)this.systemProps.get(NUMBER_OF_PORTS));
        }
        catch (Exception exception) {
            this.systemProps = this.switchsnmp.getConnectivityProps();
            try {
                n = Integer.parseInt((String)this.systemProps.get(NUMBER_OF_PORTS));
            }
            catch (Exception exception2) {
                Report.warning.log((Object)PORT_COUNT_ERROR_MESSAGE);
                this.getReportError(exception2);
            }
        }
        return n;
    }

    private int getNumberOfSensors() {
        int n = 0;
        if (this.systemProps == null) {
            this.systemProps = this.switchsnmp.getConnectivityProps();
        }
        try {
            n = Integer.parseInt((String)this.systemProps.get("connUnitNumSensors"));
        }
        catch (NumberFormatException numberFormatException) {
            this.systemProps = this.switchsnmp.getConnectivityProps();
            try {
                n = Integer.parseInt((String)this.systemProps.get(NUMBER_OF_PORTS));
            }
            catch (NumberFormatException numberFormatException2) {
                Report.warning.log((Object)SENSOR_COUNT_ERROR_MESSAGE);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        int n = 1;
        if (stringArray.length < 1) {
            System.out.println("Usage: java -Dstorade.home=<JADE_HOME>/build/demo SwitchDeviceReport <ipAddress> <noTimes>");
        }
        try {
            try {
                properties.put("ip", stringArray[0]);
                SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(stringArray[0]);
                String string = switchWWNsnmp.getWWNString();
                String string2 = switchWWNsnmp.getWWNSnmp();
                properties.put("wwn", string);
                properties.put("wwnSnmp", string2);
                try {
                    n = Integer.parseInt(stringArray[1]);
                }
                catch (Exception exception) {
                    n = 1;
                }
                int n2 = 0;
                while (n2 < n) {
                    if (n > 1) {
                        Thread.sleep(30000L);
                    }
                    SwitchDeviceReport switchDeviceReport = new SwitchDeviceReport(properties);
                    FileOutputStream fileOutputStream = new FileOutputStream(new File("/tmp/" + stringArray[0] + ".xml." + n2));
                    PrintStream printStream = new PrintStream(fileOutputStream);
                    printStream.println(switchDeviceReport.generateReport());
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var11_13 = null;
                SingleSnmpSession.destroySnmpSession();
                SingleSnmpSession.destroyAsyncSnmpSession();
                return;
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            SingleSnmpSession.destroySnmpSession();
            SingleSnmpSession.destroyAsyncSnmpSession();
            throw throwable;
        }
        SingleSnmpSession.destroySnmpSession();
        SingleSnmpSession.destroyAsyncSnmpSession();
    }

    public static class Test
    extends UnitTest {
        public void testSwitchReportGenerator() {
            Properties properties = new Properties();
            properties.setProperty("ip", "172.20.67.132");
            SwitchDeviceReport switchDeviceReport = new SwitchDeviceReport(properties);
            String string = new SwitchWWNsnmp(properties.getProperty("ip")).getWWNString();
            this.assertNotNull(string);
            this.assertEquals(switchDeviceReport.getIP(), "172.20.67.132");
        }
    }
}

