/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.service;

import com.sun.jade.device.fcswitch.ancor.sanbox.ChassisStatus;
import com.sun.jade.device.fcswitch.ancor.sanbox.Sanbox;
import com.sun.jade.device.fcswitch.fibrealliance.service.SwitchModel;
import com.sun.jade.device.fcswitch.util.snmp.EF_6000_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.FA_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.McData_FA_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.SW_Mibsnmp;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.unittest.UnitTest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;

public class SwitchModelHelper {
    private String switchModel;
    private String ip;
    private Properties p;
    private EF_6000_Mibsnmp efmibsnmp;
    private FA_Mibsnmp famibsnmp;
    private SW_Mibsnmp swmibsnmp;
    private static final String BRCD_FIRMWARE_VER2 = "v2";
    private static final String BRCD_FIRMWARE_VER3 = "v3";
    private static final String MODEL = "model";
    public static final String sccs_id = "@(#)SwitchModelHelper.java\t1.3 12/23/02 SMI";

    public SwitchModelHelper(String string, String string2, Properties properties) {
        this.p = properties;
        this.switchModel = string2;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.ip = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public SwitchModelHelper(String string, Properties properties) throws IllegalArgumentException {
        this.p = properties;
        this.switchModel = string;
        this.ip = this.p.getProperty("ip");
        if (this.switchModel == null || this.ip == null) {
            new IllegalArgumentException("The IP or the Switch type property are null. Cannot determine the exact Switch Model ");
        }
    }

    public Properties getExtraSwitchProperties() {
        int n = SwitchModel.getSwitchModelInt(this.switchModel);
        switch (n) {
            case 1: {
                Sanbox sanbox = new Sanbox(this.ip);
                ChassisStatus chassisStatus = sanbox.getChassisStatus(0);
                short s = chassisStatus.getNumOfPorts();
                if (s <= 0) break;
                this.p.setProperty("NumberOfPorts", s + "");
                break;
            }
            case 2: {
                String string;
                HashMap hashMap = new HashMap();
                this.famibsnmp = new FA_Mibsnmp(this.ip);
                hashMap = this.famibsnmp.getConnectivityProps();
                String string2 = (String)hashMap.get("connUnitNumports");
                if (string2 != null) {
                    this.p.setProperty("NumberOfPorts", string2);
                }
                if ((string = (String)hashMap.get("connUnitNumSensors")) == null) break;
                this.p.setProperty("NumberOfSensors", string);
                break;
            }
            case 3: {
                String string;
                int n2;
                this.swmibsnmp = new SW_Mibsnmp(this.ip);
                String string3 = (String)this.swmibsnmp.getPortCapacity().get("swFCPortCapacity");
                if (string3 != null) {
                    this.p.setProperty("NumberOfPorts", string3);
                }
                if ((n2 = this.swmibsnmp.getNumberOfSensors()) > 0) {
                    this.p.setProperty("NumberOfSensors", n2 + "");
                }
                if ((string = (String)this.swmibsnmp.getSystemProps().get("swFirmwareVersion")) == null) break;
                this.p.setProperty("FirmwareVersion", string);
                break;
            }
            case 4: {
                String string;
                McData_FA_Mibsnmp mcData_FA_Mibsnmp = new McData_FA_Mibsnmp(this.ip);
                HashMap hashMap = mcData_FA_Mibsnmp.getConnectivityProps();
                String string4 = (String)hashMap.get("fcConnUnitNumPorts");
                if (string4 != null) {
                    this.p.setProperty("NumberOfPorts", string4);
                }
                if ((string = (String)hashMap.get("fcConnUnitNumSensors")) != null) {
                    this.p.setProperty("NumberOfSensors", string);
                }
                this.efmibsnmp = new EF_6000_Mibsnmp(this.ip);
                String string5 = (String)this.efmibsnmp.getRevisionProps().get("ef6000SysConfigSpeed");
                if (string5 == null) break;
                this.p.setProperty("FirmwareVersion", string5);
                break;
            }
            case 0: {
                break;
            }
        }
        this.determineDeviceModel(this.p);
        return this.p;
    }

    private Properties determineDeviceModel(Properties properties) {
        Object var2_2 = null;
        String string = properties.getProperty("NumberOfPorts");
        String string2 = properties.getProperty("FirmwareVersion");
        String string3 = "model." + SwitchModel.getSwitchModelInt(this.switchModel);
        if (string != null) {
            string3 = string3 + "." + string;
            if (string2 != null) {
                if (string2.startsWith(BRCD_FIRMWARE_VER2)) {
                    string2 = BRCD_FIRMWARE_VER2;
                }
                if (string2.startsWith(BRCD_FIRMWARE_VER3)) {
                    string2 = BRCD_FIRMWARE_VER3;
                }
                string3 = string3 + "." + string2;
            }
        }
        LocalizedString localizedString = new LocalizedString("com.sun.jade.device.fcswitch.fibrealliance.service.resource.SwitchModel", string3.trim(), this.switchModel);
        properties.setProperty("DeviceDisplayModel", localizedString.getString());
        return properties;
    }

    public static void main(String[] stringArray) {
        String[][] stringArrayArray = new String[][]{{"172.20.67.100", "Brocade SilkWorm FC Switch"}, {"172.20.67.132", "Sun StorEdge network FC 2Gig switch"}, {"172.20.67.133", "Sun StorEdge network FC 2Gig switch"}, {"172.20.67.134", "Sun StorEdge network FC 2Gig switch"}, {"172.20.67.135", "Sun StorEdge network FC 2Gig switch"}, {"172.20.67.140", "Sun StorEdge network FC 2Gig switch"}, {"172.20.67.141", "Sun StorEdge network FC 2Gig switch"}, {"172.20.67.164", "Brocade SilkWorm FC Switch"}, {"172.20.67.167", "Brocade SilkWorm FC Switch"}, {"172.20.67.174", "Sun StorEdge network FC switch"}, {"172.20.67.179", "Sun StorEdge network FC switch"}, {"172.20.67.180", "Brocade SilkWorm FC Switch"}, {"172.20.67.188", "Brocade SilkWorm FC Switch"}, {"172.20.67.181", "Brocade SilkWorm FC Switch"}, {"172.20.32.89", "Brocade SilkWorm FC Switch"}, {"172.20.103.90", "McData Enterprise Director FC Switch"}, {"172.20.103.91", "McData Enterprise Director FC Switch"}, {"172.20.103.92", "McData Enterprise Director FC Switch"}};
        int n = 0;
        while (n < stringArrayArray.length) {
            System.out.println(stringArrayArray[n][0]);
            Properties properties = new Properties();
            properties.setProperty("ip", stringArrayArray[n][0]);
            SwitchModelHelper switchModelHelper = new SwitchModelHelper(stringArrayArray[n][0], stringArrayArray[n][1], properties);
            switchModelHelper.getExtraSwitchProperties().list(System.out);
            ++n;
        }
    }

    public static class Test
    extends UnitTest {
        SwitchModelHelper sh = null;

        public void testBrocadeModelHelper() {
            Properties properties = new Properties();
            properties.setProperty("ip", "172.20.67.100");
            properties.setProperty("NumberOfPorts", "8");
            properties.setProperty("FirmwareVersion", SwitchModelHelper.BRCD_FIRMWARE_VER2);
            try {
                this.sh = new SwitchModelHelper("Brocade SilkWorm FC Switch", properties);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.assertEquals("Brocade SilkWorm FC 1Gig switch-8", this.sh.determineDeviceModel(properties).getProperty("DeviceDisplayModel"));
        }

        public void testSun2G_ModelHelper() {
            Properties properties = new Properties();
            properties.setProperty("ip", "172.20.67.132");
            properties.setProperty("NumberOfPorts", "16");
            try {
                this.sh = new SwitchModelHelper("Sun StorEdge network FC 2Gig switch", properties);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.assertEquals("Sun StorEdge Network 2Gig FC switch-16", this.sh.determineDeviceModel(properties).getProperty("DeviceDisplayModel"));
        }

        public void testSun1G_ModelHelper() {
            Properties properties = new Properties();
            properties.setProperty("ip", "172.20.67.193");
            properties.setProperty("NumberOfPorts", "16");
            try {
                this.sh = new SwitchModelHelper("Sun StorEdge network FC switch", properties);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.assertEquals("Sun StorEdge Network FC switch-16", this.sh.determineDeviceModel(properties).getProperty("DeviceDisplayModel"));
        }
    }
}

