/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.service;

import com.sun.jade.apps.discovery.Probe;
import com.sun.jade.device.fcswitch.util.snmp.SwitchWWNsnmp;
import com.sun.jade.device.protocol.snmp.SNMP;
import com.sun.jade.util.unittest.UnitTest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class SwitchProbe
implements Probe {
    private boolean verbose;
    private SwitchWWNsnmp switchWWN;
    private String wwn;
    private String switchType;
    private String snmpVendorId;
    private static String probeType = "switches";
    private static String[] propertyNames = new String[]{"ip", "wwn"};
    private static final String WWN = "wwn";
    private static final String WWN_SNMP = "wwnSnmp";
    private static final String SYSTEM_DESCRIPTION = "sysDescr";
    private static final String SYSTEM_NAME = "sysName";
    private static final String SYSTEM_LOCATION = "sysLocation";
    private static final String SYSTEM_CONTACT = "sysContact";
    private static final String QLOGIC_ANCOR_ENTERPRISE_ID = "1663";
    private static final String BROCADE_ENTERPRISE_ID = "1588";
    private static final String MCDATA_ENTERPRISE_ID = "289";
    private static final String SUN_QLOGIC_ANCOR_ENTERPRISE_ID = "42.2.28.3.4.1.1";
    private static final String IP = "ip";
    private static final String IP_NO = "ipno";
    private static final String NAME = "name";
    private static final String LOCATION = "location";
    private static final String CONTACT = "contact";
    private static final String TYPE = "type";
    private static final String SWITCH = "switch";
    private static final String SWITCH_VENDOR = "vendor";
    private static final String SNMP_ENTERPRISE_ID = "snmpEnterpriseID";
    private static final int TIMEOUT = 100;
    public static final String sccs_id = "@(#)SwitchProbe.java\t1.5 10/31/02 SMI";

    public Iterator probe(String string) {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        SNMP sNMP = new SNMP(100);
        Iterator iterator = sNMP.probe(string);
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            String string2 = properties.getProperty(IP);
            String string3 = properties.getProperty(IP_NO);
            String string4 = properties.getProperty(SYSTEM_DESCRIPTION);
            this.switchWWN = new SwitchWWNsnmp(string2);
            this.wwn = this.switchWWN.getWWNString();
            this.switchType = this.switchWWN.getDeviceType();
            this.snmpVendorId = this.switchWWN.getVendorSNMPId();
            if (!QLOGIC_ANCOR_ENTERPRISE_ID.startsWith(this.snmpVendorId) && !BROCADE_ENTERPRISE_ID.startsWith(this.snmpVendorId) && !MCDATA_ENTERPRISE_ID.startsWith(this.snmpVendorId) && !this.snmpVendorId.startsWith(SUN_QLOGIC_ANCOR_ENTERPRISE_ID)) continue;
            Properties properties2 = new Properties();
            if (string2 != null) {
                properties2.setProperty(IP, string2);
            }
            if (string3 != null) {
                properties2.setProperty(IP_NO, string3);
            }
            properties2.setProperty(NAME, properties.getProperty(SYSTEM_NAME));
            properties2.setProperty(SNMP_ENTERPRISE_ID, this.snmpVendorId);
            if (this.wwn != null) {
                properties2.put(WWN, this.wwn);
                properties2.put(WWN_SNMP, this.switchWWN.getWWNSnmp());
            }
            properties2.setProperty(TYPE, SWITCH);
            properties2.setProperty(SWITCH_VENDOR, this.switchType);
            arrayList.add(properties2);
        }
        return arrayList.iterator();
    }

    public String getProbeType() {
        return probeType;
    }

    public String[] getProbeProperties() {
        return propertyNames;
    }

    public static void main(String[] stringArray) {
        SwitchProbe switchProbe = new SwitchProbe();
        switchProbe.verbose = true;
        Iterator iterator = switchProbe.probe(stringArray[0]);
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            properties.list(System.out);
        }
        System.exit(0);
    }

    public static class Test
    extends UnitTest {
        public void testSwitchProbe() {
            SwitchProbe switchProbe = new SwitchProbe();
            Iterator iterator = switchProbe.probe("172.20.67.101");
            while (iterator.hasNext()) {
                Properties properties = (Properties)iterator.next();
                this.assertEquals(properties.getProperty(SwitchProbe.SWITCH_VENDOR), "QLogic SANbox2 FC Switch");
                this.assertEquals(properties.getProperty(SwitchProbe.IP_NO), "172.20.67.101");
                this.assertEquals(properties.getProperty(SwitchProbe.IP), "172.20.67.101");
                this.assertEquals(properties.getProperty(SwitchProbe.WWN_SNMP), "16.0.0.192.221.0.183.218.0.0.0.0.0.0.0.0");
                this.assertEquals(properties.getProperty(SwitchProbe.WWN), "100000c0dd00b7da");
                this.assertEquals(properties.getProperty(SwitchProbe.SNMP_ENTERPRISE_ID), SwitchProbe.QLOGIC_ANCOR_ENTERPRISE_ID);
            }
        }
    }
}

