/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.snmp;

import com.sun.jade.device.fcswitch.util.snmp.FIBRE_CHANNEL_MGMT_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.Generic_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.SwitchWWNsnmp;
import com.sun.jade.util.unittest.UnitTest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class McData_FA_Mibsnmp
extends Generic_Mibsnmp {
    private String wwn = null;
    private String ipno = null;
    private static final String IP = "ip";
    private static final String SNMP_WWN = "wwnSnmp";
    private static final String DOT = ".";
    private static String[] linkProps = new String[]{"fcConnUnitLinkPortWwnY"};
    private static String[] sensorProps = new String[]{"fcConnUnitSensorType", "fcConnUnitSensorMessage", "fcConnUnitSensorInfo", "fcConnUnitSensorStatus", "fcConnUnitSensorName"};
    private static String[] portProps = new String[]{"fcConnUnitPortType", "fcConnUnitPortState", "fcConnUnitPortStatus", "fcConnUnitPortWwn", "fcConnUnitPortSpeed"};
    private static String[] portstatProps = new String[]{"fcConnUnitPortStatCountInvalidCRC", "fcConnUnitPortStatCountInvalidTxWords", "fcConnUnitPortStatCountLossofSignal", "fcConnUnitPortStatCountLossofSynchronization", "fcConnUnitPortStatCountFramesTooLong", "fcConnUnitPortStatCountFramesTooShort"};
    private static String[] connectivityProps = new String[]{"fcConnUnitState", "fcConnUnitStatus", "fcConnUnitNumSensors", "fcConnUnitNumRevs", "fcConnUnitNumPorts"};
    public static final String sccs_id = "@(#)McData_FA_Mibsnmp.java\t1.8 12/23/02 SMI";

    public McData_FA_Mibsnmp(String string) {
        super(string);
        this.ipno = string;
        this.addOidTable(new FIBRE_CHANNEL_MGMT_MIBOidTable());
        SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(this.ipno);
        this.wwn = switchWWNsnmp.getWWNSnmp();
    }

    public McData_FA_Mibsnmp(Properties properties) {
        super(properties.getProperty(IP));
        this.addOidTable(new FIBRE_CHANNEL_MGMT_MIBOidTable());
        this.wwn = properties.getProperty(SNMP_WWN);
        this.ipno = properties.getProperty(IP);
    }

    public HashMap getMcDataLinkProps(String string) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, linkProps, this.wwn + DOT + string, "Hex");
        return hashMap;
    }

    public HashMap getSensorProps(int n) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, sensorProps, this.wwn + DOT + n);
        return hashMap;
    }

    public HashMap getPortProps(int n) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, portProps, this.wwn + DOT + n, "Hex");
        return hashMap;
    }

    public HashMap getPortStatProps(int n) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, portstatProps, this.wwn + DOT + n);
        return hashMap;
    }

    public HashMap getConnectivityProps() {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, connectivityProps, this.wwn);
        return hashMap;
    }

    public static void main(String[] stringArray) {
        String string;
        Object object;
        Object var1_1 = null;
        if (stringArray.length < 2) {
            System.out.println("usage <switch-ip-addresss> <type> [index]");
            System.exit(1);
        }
        McData_FA_Mibsnmp mcData_FA_Mibsnmp = new McData_FA_Mibsnmp(stringArray[0]);
        String string2 = stringArray[1];
        int n = 0;
        if (stringArray.length > 2) {
            n = Integer.parseInt(stringArray[2]);
        }
        HashMap hashMap = null;
        if ("link".equals(string2)) {
            hashMap = mcData_FA_Mibsnmp.getMcDataLinkProps("0");
        } else if ("sensor".equals(string2)) {
            hashMap = mcData_FA_Mibsnmp.getSensorProps(n);
        } else if ("port".equals(string2)) {
            hashMap = mcData_FA_Mibsnmp.getPortProps(n);
        } else if ("portstat".equals(string2)) {
            hashMap = mcData_FA_Mibsnmp.getPortStatProps(n);
        } else if ("connectivity".equals(string2)) {
            hashMap = mcData_FA_Mibsnmp.getConnectivityProps();
        } else if ("unitTest".equals(string2)) {
            int n2 = 1;
            while (n2 <= 32) {
                hashMap = mcData_FA_Mibsnmp.getPortProps(1);
                object = hashMap.keySet().iterator();
                System.out.println("FOR PORT " + n2);
                while (object.hasNext()) {
                    string = (String)object.next();
                    String string3 = (String)hashMap.get(string);
                    System.out.println("Attribute Name: " + string + "\t Attribute Value: " + string3);
                }
                ++n2;
            }
            System.exit(0);
        } else {
            System.out.println("bad type=" + string2);
            System.out.println("[port|connectivity|portstat|connectivityUnit|revision|sensor|link|unitTest]");
            System.exit(0);
        }
        if (hashMap == null) {
            System.out.println("No data returned");
            System.exit(0);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            string = (String)hashMap.get(object);
            System.out.println("Attribute Name: " + (String)object + "\t Attribute Value: " + string);
        }
    }

    public static class Test
    extends UnitTest {
        private McData_FA_Mibsnmp fcswitch = new McData_FA_Mibsnmp("172.20.103.90");

        public void testFA_MIB_ConnectivityTable() {
            HashMap hashMap = this.fcswitch.getConnectivityProps();
            this.assertNotNull((String)hashMap.get("fcConnUnitState"));
            this.assertNotNull((String)hashMap.get("fcConnUnitStatus"));
            this.assertNotNull((String)hashMap.get("fcConnUnitNumSensors"));
            this.assertNotNull((String)hashMap.get("fcConnUnitStatus"));
        }

        public void testFA_MIB_SensorTable() {
            HashMap hashMap = this.fcswitch.getSensorProps(1);
            this.assertNotNull((String)hashMap.get("fcConnUnitSensorType"));
            this.assertNotNull((String)hashMap.get("fcConnUnitSensorStatus"));
        }

        public void testFA_MIB_PortTable() {
            HashMap hashMap = this.fcswitch.getPortProps(1);
            this.assertNotNull((String)hashMap.get("fcConnUnitPortStatus"));
            this.assertNotNull((String)hashMap.get("fcConnUnitPortWwn"));
        }
    }
}

