/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.common.clip;

public final class CommandOption {
    private final char shortName;
    private final String longName;
    private final boolean required;
    private final Boolean shortValue;

    private CommandOption(char c, String string, boolean bl, Boolean bl2) {
        if (!CommandOption.isValidShortName(c)) {
            throw new IllegalArgumentException("invalid shortName, " + c);
        }
        if (!CommandOption.isValidLongName(string)) {
            throw new IllegalArgumentException("invalid longName, " + string);
        }
        this.shortName = c;
        this.longName = string;
        this.required = bl;
        this.shortValue = bl2;
    }

    public static CommandOption newOption(char c, String string, boolean bl) {
        return new CommandOption(c, string, bl, null);
    }

    public static CommandOption newBooleanOption(char c, String string, boolean bl) {
        return new CommandOption(c, string, false, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public static boolean isValidShortName(char c) {
        return Character.isLowerCase(c);
    }

    public static boolean isValidLongName(String string) {
        if (string == null) {
            return true;
        }
        if (string.length() < 2 || !Character.isLowerCase(string.charAt(0))) {
            return false;
        }
        boolean bl = false;
        int n = 1;
        while (n < string.length()) {
            boolean bl2;
            char c = string.charAt(n);
            boolean bl3 = c == '-';
            boolean bl4 = bl2 = Character.isDigit(c) || Character.isLowerCase(c);
            if (!(bl2 || !bl && bl3)) {
                return false;
            }
            bl = bl3;
            ++n;
        }
        return true;
    }

    public char getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isBooleanOption() {
        return this.shortValue != null;
    }

    public Boolean getBooleanShortValue() {
        return this.shortValue;
    }
}

