/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.common.clip;

import com.sun.netstorage.mgmt.common.clip.Command;
import com.sun.netstorage.mgmt.common.clip.StatementOption;
import java.util.HashMap;
import java.util.Map;

public final class Statement {
    private final Command subCommand;
    private final Map optionMap;
    private final String[] operands;

    Statement(Command command, Map map, String[] stringArray) {
        this.subCommand = command;
        this.optionMap = map;
        this.operands = stringArray != null ? stringArray : new String[]{};
    }

    public Statement(Command command, StatementOption[] statementOptionArray, String[] stringArray) {
        this.subCommand = command;
        this.optionMap = new HashMap();
        String[] stringArray2 = this.operands = stringArray != null ? stringArray : new String[]{};
        if (statementOptionArray != null) {
            int n = 0;
            while (n < statementOptionArray.length) {
                this.optionMap.put(new Character(statementOptionArray[n].getOption().getShortName()), statementOptionArray[n]);
                ++n;
            }
        }
    }

    public Command getSubCommand() {
        return this.subCommand;
    }

    public StatementOption[] getOptions() {
        return this.optionMap.values().toArray(new StatementOption[this.optionMap.size()]);
    }

    public String[] getOperands() {
        return this.operands;
    }

    public StatementOption getOption(char c) {
        return (StatementOption)this.optionMap.get(new Character(c));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.subCommand != null) {
            stringBuffer.append(this.subCommand.getName());
            stringBuffer.append(' ');
        }
        StatementOption[] statementOptionArray = this.getOptions();
        int n = 0;
        while (n < statementOptionArray.length) {
            stringBuffer.append(statementOptionArray[n].toString());
            stringBuffer.append(' ');
            ++n;
        }
        String[] stringArray = this.getOperands();
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringBuffer.append(stringArray[n2]);
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString().trim();
    }
}

