/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.common.clip;

import com.sun.netstorage.mgmt.common.clip.Command;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.common.clip.StatementOption;
import java.io.PrintWriter;
import java.util.HashMap;

public abstract class Utility
implements Command {
    public static final int PARSE_ERROR = 1;
    private static final String HELP_OPTION = "--help";
    private static final String VERSION_OPTION = "--version";
    private static final String HELP_SHORT_OPTION = "-?";
    private static final String VERSION_SHORT_OPTION = "-V";
    private static final String BUNDLE = "com.sun.netstorage.mgmt.common.clip.Localization";
    private final String name;
    private final String description;
    private final CommandOption[] options;
    private final Command[] subCommands;

    protected Utility(String string, String string2, Command[] commandArray) {
        this(string, string2, commandArray, null);
    }

    protected Utility(String string, String string2, CommandOption[] commandOptionArray) {
        this(string, string2, null, commandOptionArray);
    }

    protected Utility(String string, String string2, Command[] commandArray, CommandOption[] commandOptionArray) {
        if (string == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("description == null");
        }
        this.name = string;
        this.description = string2;
        this.subCommands = commandArray != null ? commandArray : new Command[]{};
        this.options = commandOptionArray != null ? commandOptionArray : new CommandOption[]{};
    }

    public abstract void printVersion(PrintWriter var1);

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final CommandOption[] getOptions() {
        return this.options;
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println(this.getDescription());
        if (this.subCommands.length > 0) {
            printWriter.println();
            printWriter.println(Localization.getString(BUNDLE, "subcommands"));
            int n = 0;
            int n2 = 0;
            n2 = 0;
            while (n2 < this.subCommands.length) {
                n = Math.max(n, this.subCommands[n2].getName().length());
                ++n2;
            }
            n2 = 0;
            while (n2 < this.subCommands.length) {
                printWriter.print("  ");
                String string = this.subCommands[n2].getName();
                printWriter.print(string);
                int n3 = n + 2 - string.length();
                while (n3 > 0) {
                    printWriter.print(' ');
                    --n3;
                }
                printWriter.println(this.subCommands[n2].getDescription());
                ++n2;
            }
            if (this.subCommands.length > 0) {
                printWriter.println(Localization.getString(BUNDLE, "subHelp", this.getName()));
            }
        }
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Command command = statement.getSubCommand();
        if (command != null) {
            command.execute(printWriter, statement);
        }
    }

    public final void executeCLI(String[] stringArray) {
        int n = 125;
        try {
            PrintWriter printWriter = new PrintWriter(System.out);
            PrintWriter printWriter2 = new PrintWriter(System.err);
            n = this.executeCLI(printWriter, printWriter2, stringArray);
            printWriter.close();
            printWriter2.close();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println(Localization.getString(BUNDLE, "error", new String[]{this.getName(), "125", throwable.getMessage()}));
        }
        System.exit(n);
    }

    /*
     * Unable to fully structure code
     */
    public final int executeCLI(PrintWriter var1_1, PrintWriter var2_2, String[] var3_3) {
        block6: {
            block7: {
                try {
                    var4_4 = this.parseArguments(var1_1, var2_2, var3_3);
                    if (var4_4 == null) {
                        return 0;
                    }
                    if (System.getProperty("clip.debug") != null) {
                        var1_1.println("DEBUG: " + this.getName() + " " + var4_4);
                    }
                    this.execute(var1_1, var4_4);
                    break block6;
                }
                catch (StatementException var4_5) {
                    var2_2.println(Localization.getString("com.sun.netstorage.mgmt.common.clip.Localization", "error", new String[]{this.getName(), Integer.toString(1), var4_5.getMessage()}));
                    var2_2.println(Localization.getString("com.sun.netstorage.mgmt.common.clip.Localization", "usage", this.getName()));
                    return 1;
                }
                catch (CommandException var5_6) {
                    var2_2.println(Localization.getString("com.sun.netstorage.mgmt.common.clip.Localization", "error", new String[]{this.getName(), Integer.toString(var5_6.getErrorCode()), var5_6.getMessage()}));
                    if (System.getProperty("clip.debug") == null || var5_6.getCause() == null) break block7;
                    var2_2.print("DEBUG: ");
                    var6_7 = var5_6.getCause();
                    ** while (var6_7 != null)
                }
lbl-1000:
                // 1 sources

                {
                    var6_7.printStackTrace(var2_2);
                    var6_7 = var6_7 instanceof Exception != false ? ((Exception)var6_7).getCause() : null;
                    continue;
                }
            }
            var2_2.println(Localization.getString("com.sun.netstorage.mgmt.common.clip.Localization", "usage", this.getName()));
            return var5_6.getErrorCode();
        }
        return 0;
    }

    public final Statement parseArguments(PrintWriter printWriter, PrintWriter printWriter2, String[] stringArray) throws StatementException {
        int n;
        Object object;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] == null) {
                throw new IllegalArgumentException("arguments[" + n2 + "] = null");
            }
            ++n2;
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new StatementException(Localization.getString(BUNDLE, "noArguments"));
        }
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        Command command = null;
        if (!stringArray2[0].startsWith("-") && (command = this.getSubCommand(stringArray2[0])) == null) {
            throw new StatementException(Localization.getString(BUNDLE, "invalidSubCommand", stringArray2[0]));
        }
        if (stringArray2[0].equals(VERSION_OPTION) || stringArray2[0].equals(VERSION_SHORT_OPTION)) {
            this.printVersion(printWriter);
            return null;
        }
        HashMap<Character, StatementOption> hashMap = new HashMap<Character, StatementOption>();
        Command command2 = command != null ? command : this;
        int n3 = command == null ? 0 : 1;
        while (n3 < stringArray2.length) {
            if (!stringArray2[n3].startsWith("-") || stringArray2[n3].equals("--")) break;
            object = null;
            n = -1;
            CommandOption commandOption = null;
            StatementOption statementOption = null;
            if (stringArray2[n3].startsWith("--")) {
                object = stringArray2[n3];
                if (stringArray2[n3].equals(HELP_OPTION)) {
                    command2.printHelp(printWriter);
                    return null;
                }
                boolean bl = stringArray2[n3].startsWith("--no-");
                commandOption = this.getOption(command2, stringArray2[n3].substring(bl ? 5 : 2));
                if (commandOption != null && commandOption.isBooleanOption()) {
                    statementOption = new StatementOption(commandOption, !bl);
                }
            } else if (stringArray2[n3].length() == 1) {
                object = stringArray2[n3];
            } else {
                object = stringArray2[n3].substring(0, 2);
                if (stringArray2[n3].equals(HELP_SHORT_OPTION)) {
                    command2.printHelp(printWriter);
                    return null;
                }
                commandOption = this.getOption(command2, stringArray2[n3].charAt(1));
                n = n3;
                if (commandOption != null && commandOption.isBooleanOption()) {
                    statementOption = new StatementOption(commandOption, commandOption.getBooleanShortValue());
                }
            }
            if (commandOption == null) {
                throw new StatementException(Localization.getString(BUNDLE, "invalidOption", new String[]{command2.getName(), object}));
            }
            if (!commandOption.isBooleanOption()) {
                if (n3 + 1 >= stringArray2.length || stringArray2[n3 + 1].startsWith("-")) {
                    throw new StatementException(Localization.getString(BUNDLE, "missingOptionArgument", object));
                }
                statementOption = new StatementOption(commandOption, stringArray2[++n3]);
            }
            if (n != -1 && stringArray2[n].length() > 2) {
                stringArray2[n] = "-" + stringArray2[n].substring(2);
                if (n3 != n) {
                    String[] stringArray3 = new String[stringArray2.length - n3];
                    stringArray3[0] = stringArray2[n];
                    System.arraycopy(stringArray2, n3 + 1, stringArray3, 1, stringArray3.length - 1);
                    stringArray2 = stringArray3;
                    n3 = -1;
                } else {
                    n3 = n - 1;
                }
            }
            hashMap.put(new Character(commandOption.getShortName()), statementOption);
            ++n3;
        }
        object = command2.getOptions();
        n = 0;
        while (n < ((CommandOption[])object).length) {
            if (object[n].isRequired() && hashMap.get(new Character(object[n].getShortName())) == null) {
                throw new StatementException(Localization.getString(BUNDLE, "requiredOptionMissing", new Character(object[n].getShortName()).toString()));
            }
            ++n;
        }
        if (n3 < stringArray2.length && stringArray2[n3].equals("--")) {
            ++n3;
        } else {
            int n4 = n3;
            while (n4 < stringArray2.length) {
                if (stringArray2[n4].startsWith("-")) {
                    throw new StatementException(Localization.getString(BUNDLE, "optionAsOperand", stringArray2[n4]));
                }
                ++n4;
            }
        }
        String[] stringArray4 = new String[stringArray2.length - n3];
        System.arraycopy(stringArray2, n3, stringArray4, 0, stringArray4.length);
        return new Statement(command, hashMap, stringArray4);
    }

    private Command getSubCommand(String string) {
        if (string != null) {
            int n = 0;
            while (n < this.subCommands.length) {
                if (string.equals(this.subCommands[n].getName())) {
                    return this.subCommands[n];
                }
                ++n;
            }
        }
        return null;
    }

    private CommandOption getOption(Command command, char c) {
        CommandOption[] commandOptionArray = command.getOptions();
        int n = 0;
        while (n < commandOptionArray.length) {
            if (commandOptionArray[n].getShortName() == c) {
                return commandOptionArray[n];
            }
            ++n;
        }
        return null;
    }

    private CommandOption getOption(Command command, String string) {
        if (string != null) {
            CommandOption[] commandOptionArray = command.getOptions();
            int n = 0;
            while (n < commandOptionArray.length) {
                if (string.equals(commandOptionArray[n].getLongName())) {
                    return commandOptionArray[n];
                }
                ++n;
            }
        }
        return null;
    }
}

