/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.admin;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.admin.IPAdminCommand;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IPAdmin
extends HttpServlet {
    private String PAGE_URL;
    private IPAdminCommand ipsCommand = null;
    private static final int DEFAULT_SORT_COL = 2;
    private static final TableColumn[] COLUMNS = new TableColumn[3];
    private static final int ID_COLUMN = 0;
    private static final int IP_COLUMN = 1;
    private static final int USER_COLUMN = 2;
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private String[] buttonItems = new String[]{"ips_action_button1", "ips_action_button2", "ips_action_button3"};
    private boolean[] buttonsOff = new boolean[]{true, false, false};
    private boolean[] buttonsOn = new boolean[]{true, true, true};

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.out = httpServletResponse.getWriter();
        try {
            object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.ADMIN_IPADMIN_PAGE));
            if (object == null || !((String)object).equalsIgnoreCase("Admin")) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "not_authorized"));
                this.displayMasthead();
                return;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        object = null;
        this.PAGE_URL = httpServletRequest.getRequestURI();
        if (httpServletRequest.getQueryString() != null) {
            this.PAGE_URL = this.PAGE_URL + "?" + httpServletRequest.getQueryString();
        }
        boolean bl = false;
        try {
            UtilsWeb.noCacheHeader(httpServletResponse);
            String string = httpServletRequest.getParameter("submitcontrol");
            if (string != null) {
                String string2 = httpServletRequest.getParameter("ip");
                if (string.equals("ips_action_button1")) {
                    UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.IPADMIN_ADD_PAGE), httpServletResponse);
                    bl = true;
                } else if (string.equals("ips_action_button2")) {
                    if (string2 != null) {
                        UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.IPADMIN_DEL_PAGE) + "?ip=" + httpServletRequest.getParameter("ip"), httpServletResponse);
                        bl = true;
                    } else {
                        HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "ips_msg_no_ip"));
                    }
                } else if (string.equals("ips_action_button3")) {
                    if (string2 != null) {
                        UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.IPADMIN_MOD_PAGE) + "?ip=" + httpServletRequest.getParameter("ip"), httpServletResponse);
                        bl = true;
                    } else {
                        HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "ips_msg_no_ip"));
                    }
                }
            }
            this.ipsCommand = new IPAdminCommand();
            this.ipsCommand.run();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            object = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        if (!bl) {
            HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "credential_info_message"));
            this.displayMasthead();
            if (object != null) {
                this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.ADMIN_IPADMIN_PAGE, (Throwable)object));
                this.out.flush();
            } else {
                this.out.println(HTMLTags.getContentStartTags(this.PAGE_URL));
                this.out.println(this.getIPTable());
                this.out.println(HTMLTags.getContentEndTags());
                this.out.close();
            }
        }
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Administration", "Administration", "Credentials", NSMPages.getPageHelp(NSMPages.ADMIN_IPADMIN_PAGE), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.ADMIN_IPADMIN_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    public String getIPTable() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.ipsCommand.count();
        HTMLTags.TableInfo tableInfo = HTMLTags.getTableInfo(this.request, 2, n);
        int n2 = tableInfo.sortColumn;
        int n3 = tableInfo.firstRow;
        int n4 = tableInfo.pageSize;
        String[][] stringArray = this.ipsCommand.getKeyInfo();
        Arrays.sort(stringArray, new SmartColumnComparator(n2));
        int n5 = Math.min(n4, n - n3);
        String[][] stringArray2 = new String[n5][];
        System.arraycopy(stringArray, n3, stringArray2, 0, n5);
        int n6 = 0;
        while (n6 < n5) {
            stringArray2[n6][0] = "<input type=radio name=ip value=" + stringArray2[n6][0] + ">";
            ++n6;
        }
        if (n <= n4) {
            stringBuffer.append(HTMLTags.getTableTitleTag(Localization.getString(BUNDLE, "ips_table_title")));
        } else {
            stringBuffer.append(HTMLTags.getTableTitleTag(Localization.getString(BUNDLE, "ips_table_title"), n3, n, n4));
        }
        if (n == 0) {
            stringBuffer.append(HTMLTags.getActionButtonsTag(BUNDLE, "actionMenuTitle", this.buttonItems, this.buttonsOff));
        } else {
            stringBuffer.append(HTMLTags.getActionButtonsTag(BUNDLE, "actionMenuTitle", this.buttonItems, this.buttonsOn));
        }
        stringBuffer.append(HTMLTags.getTableTag(this.PAGE_URL, COLUMNS, stringArray2, n2, n3, n, n4));
        return stringBuffer.toString();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (COLUMNS[0] == null) {
            IPAdmin.COLUMNS[0] = new TableColumn("    ", false, "\"left\"");
            IPAdmin.COLUMNS[1] = new TableColumn(Localization.getString(BUNDLE, "ips_table_title_ips"), true, "\"left\"", true);
            IPAdmin.COLUMNS[2] = new TableColumn(Localization.getString(BUNDLE, "ips_table_title_user"), true, "\"left\"");
        }
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "This is the main IPAdmin Notification page.";
    }
}

