/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.admin;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.admin.IPAdminBean;
import com.sun.netstorage.mgmt.nsmui.admin.IPAdminCommand;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IPAdminAdd
extends HttpServlet {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private IPAdminCommand ipsCommand = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private IPAdminBean ib;

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.out = httpServletResponse.getWriter();
        try {
            object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.IPADMIN_ADD_PAGE));
            if (object == null || !((String)object).equalsIgnoreCase("Admin")) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "not_authorized"));
                this.displayMasthead();
                return;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        object = null;
        try {
            UtilsWeb.noCacheHeader(httpServletResponse);
            this.ipsCommand = new IPAdminCommand();
            this.ipsCommand.run();
            httpServletRequest.setAttribute("IPAdminBeanId", (Object)this.ib);
            String string = httpServletRequest.getParameter("submitcontrol");
            if (string != null) {
                if (string.equals("savebutton")) {
                    this.setupInitialValues(false);
                    if (this.ib.getIP().length() == 0) {
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "add_ips_msg_empty_ip"));
                    } else if (this.ib.getUser().length() == 0) {
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "add_ips_msg_empty_user"));
                    } else if (!this.ib.getPassword().equals(this.ib.getVerifyPassword())) {
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "add_ips_passwords_dont_match"));
                    } else if (this.ipsCommand.keyExists(this.ib.getIP())) {
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "add_ips_address_exists", this.ib.getIP()));
                    } else {
                        this.ipsCommand.setAgentKey(this.ib.getIP(), this.ib.getUser(), this.ib.getPassword());
                        HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "add_ips_msg_ip_added"));
                    }
                    this.displayMasthead();
                    UtilsWeb.include(this.getServletContext(), "/jsp/ipadminadd.jsp", httpServletRequest, httpServletResponse);
                } else if (string.equals("cancelbutton")) {
                    UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_IPADMIN_PAGE), httpServletResponse);
                }
            } else {
                this.setupInitialValues(true);
                this.displayMasthead();
                UtilsWeb.include(this.getServletContext(), "/jsp/ipadminadd.jsp", httpServletRequest, httpServletResponse);
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            object = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        if (object != null) {
            this.displayMasthead();
            this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.IPADMIN_ADD_PAGE, (Throwable)object));
            this.out.flush();
        }
    }

    public void setupInitialValues(boolean bl) {
        if (bl) {
            this.ib.setIP("");
            this.ib.setUser("");
            this.ib.setPassword("");
            this.ib.setVerifyPassword("");
        } else {
            this.ib.setIP(this.request.getParameter("iptext"));
            this.ib.setUser(this.request.getParameter("usertext"));
            this.ib.setPassword(this.request.getParameter("passwordtext"));
            this.ib.setVerifyPassword(this.request.getParameter("verifytext"));
        }
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Administration", "Administration", "Credentials", NSMPages.getPageHelp(NSMPages.IPADMIN_ADD_PAGE), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.IPADMIN_ADD_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.ib = new IPAdminBean();
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "This is the IP Administration Add page.";
    }
}

