/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.admin;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.facility.credential.CredentialFacilityAdmin;
import com.sun.netstorage.mgmt.nsmui.common.Configuration;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Enumeration;
import java.util.Hashtable;

public class IPAdminCommand {
    private static String BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private Hashtable theKeys;
    private CredentialFacilityAdmin cService;

    public IPAdminCommand() throws NSMUIException {
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new SecurityManager());
            }
            String string = Configuration.getProperty("REGISTRY_HOST");
            Registry registry = null;
            try {
                registry = LocateRegistry.getRegistry(string, Integer.parseInt(Configuration.getProperty("NSM_RMI_REGISTRY_PORT")));
            }
            catch (NumberFormatException numberFormatException) {
                registry = LocateRegistry.getRegistry(string);
            }
            this.cService = (CredentialFacilityAdmin)registry.lookup("com.sun.netstorage.mgmt.facility.credential");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_cred_service"), throwable);
        }
    }

    public void run() throws NSMUIException {
        this.theKeys = this.getKeys();
    }

    public Hashtable getKeys() throws NSMUIException {
        String[] stringArray;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            stringArray = this.cService.getKeys();
        }
        catch (Exception exception) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_using_credentials_service"), exception);
        }
        if (stringArray.length != 0) {
            int n = 0;
            while (n < stringArray.length) {
                hashtable.put(stringArray[n], this.getUsername(stringArray[n]));
                ++n;
            }
        }
        return hashtable;
    }

    public void setAgentKey(String string, String string2, String string3) throws NSMUIException {
        try {
            this.cService.addCredential(string, string2, string3.toCharArray());
        }
        catch (Exception exception) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_using_credentials_service"), exception);
        }
    }

    public String getUsername(String string) throws NSMUIException {
        String string2 = null;
        try {
            string2 = this.cService.getUsername(string);
        }
        catch (Exception exception) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_using_credentials_service"), exception);
        }
        return string2;
    }

    public void deleteAgentKey(String string) throws NSMUIException {
        try {
            this.cService.deleteCredential(string);
        }
        catch (Exception exception) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_using_credentials_service"), exception);
        }
    }

    public void modifyAgentKey(String string, String string2, String string3) throws NSMUIException {
        this.deleteAgentKey(string);
        this.setAgentKey(string, string2, string3);
    }

    public boolean keyExists(String string) throws NSMUIException {
        String string2 = this.getUsername(string);
        return string2 != null;
    }

    public int count() {
        return this.theKeys.size();
    }

    public String[][] getKeyInfo() {
        String[][] stringArray = new String[this.theKeys.size()][3];
        Enumeration enumeration = this.theKeys.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string;
            stringArray[n][0] = string = (String)enumeration.nextElement();
            stringArray[n][1] = string;
            stringArray[n][2] = (String)this.theKeys.get(string);
            ++n;
        }
        return stringArray;
    }
}

