/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.admin;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.common.datamodel.User;
import com.sun.netstorage.mgmt.component.model.api.gui.GuiPersistenceManager;
import com.sun.netstorage.mgmt.nsmui.common.DataInterpretationException;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.login.UnixUser;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public class UsersCommand {
    private static int COLUMNS = 3;
    private static String BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private static final String verifierName = "getuserdata";
    private User[] users;
    private Hashtable usersHashtable;
    private GuiPersistenceManager theGuiPM;
    private static String verifierCommand;

    public UsersCommand() throws NSMUIException {
        try {
            this.theGuiPM = Utils.getGuiPersistenceManager();
            this.users = this.theGuiPM.getUsers();
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException(Localization.getString(BUNDLE, "data_retrieval_error"), persistenceException);
        }
        catch (Exception exception) {
            throw new DataInterpretationException(Localization.getString(BUNDLE, "error_in_model_object"), exception);
        }
    }

    public void run() throws NSMUIException {
        this.usersHashtable = this.mineUsers(this.users);
    }

    public String[][] getUsers() {
        String[][] stringArray = new String[this.usersHashtable.size()][COLUMNS];
        if (this.usersHashtable == null) {
            return new String[][]{new String[0]};
        }
        Enumeration enumeration = this.usersHashtable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            User user = (User)enumeration.nextElement();
            stringArray[n][0] = user.getName();
            stringArray[n][1] = user.getName();
            stringArray[n][2] = Localization.getString(BUNDLE, user.getRole());
            ++n;
        }
        return stringArray;
    }

    public Hashtable getUser(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        User user = (User)this.usersHashtable.get(string);
        if (user == null) {
            return null;
        }
        hashtable.put("ID", user.getName());
        hashtable.put("User", user.getName());
        hashtable.put("Role", user.getRole());
        return hashtable;
    }

    public int count() {
        return this.usersHashtable.size();
    }

    public void addUser(String string, String string2) throws NSMUIException {
        try {
            this.theGuiPM.saveUser(new User(string, string2));
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException(Localization.getString(BUNDLE, "data_retrieval_error"), persistenceException);
        }
        catch (Exception exception) {
            throw new DataInterpretationException(Localization.getString(BUNDLE, "error_in_model_object"), exception);
        }
    }

    public void deleteUser(String string) throws NSMUIException {
        try {
            User user = this.theGuiPM.getUser(string);
            this.theGuiPM.deleteUser(user);
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException(Localization.getString(BUNDLE, "data_retrieval_error"), persistenceException);
        }
        catch (Exception exception) {
            throw new DataInterpretationException(Localization.getString(BUNDLE, "error_in_model_object"), exception);
        }
    }

    public String modifyUser(String string, String string2) throws NSMUIException {
        try {
            this.theGuiPM.saveUser(new User(string, string2));
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException(Localization.getString(BUNDLE, "data_retrieval_error"), persistenceException);
        }
        catch (Exception exception) {
            throw new DataInterpretationException(Localization.getString(BUNDLE, "error_in_model_object"), exception);
        }
        return null;
    }

    public boolean userExists(String string) throws NSMUIException {
        Hashtable hashtable = new Hashtable();
        hashtable = this.getUser(string);
        if (hashtable == null) {
            return false;
        }
        return ((String)hashtable.get("User")).equals(string);
    }

    private Hashtable mineUsers(User[] userArray) {
        Hashtable<String, User> hashtable = new Hashtable<String, User>();
        int n = 0;
        while (n < userArray.length) {
            hashtable.put(userArray[n].getName(), userArray[n]);
            ++n;
        }
        return hashtable;
    }

    static boolean isKnownUser(String string, String string2) throws NSMUIException {
        if (string2 == null) {
            throw new NSMUIException(Localization.getString(BUNDLE, "null_path"));
        }
        verifierCommand = string2 + verifierName;
        if (!new File(verifierCommand).exists()) {
            throw new NSMUIException(Localization.getString(BUNDLE, "verifier_not_found", verifierCommand));
        }
        try {
            new UnixUser();
            return UnixUser.userExists(verifierCommand, string.getBytes());
        }
        catch (Exception exception) {
            throw new NSMUIException(Localization.getString(BUNDLE, "verifier_error", verifierCommand), exception);
        }
    }
}

