/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.admin;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.admin.UsersBean;
import com.sun.netstorage.mgmt.nsmui.admin.UsersCommand;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UsersMod
extends HttpServlet {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private UsersCommand usersCommand = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private String idValue;
    private UsersBean sb;

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.out = httpServletResponse.getWriter();
        try {
            object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.USERS_MOD_PAGE));
            if (object == null || !((String)object).equalsIgnoreCase("Admin")) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "not_authorized"));
                this.displayMasthead();
                return;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        object = null;
        try {
            UtilsWeb.noCacheHeader(httpServletResponse);
            this.idValue = httpServletRequest.getParameter("id");
            if (this.idValue == null) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "del_users_msg_no_id"));
                UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_USERS_PAGE), httpServletResponse);
            } else {
                this.usersCommand = new UsersCommand();
                this.usersCommand.run();
                httpServletRequest.setAttribute("UsersBeanId", (Object)this.sb);
                Hashtable hashtable = this.usersCommand.getUser(this.idValue);
                if (hashtable == null) {
                    HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "mod_users_msg_no_user"));
                    this.displayMasthead();
                } else {
                    String string = (String)hashtable.get("User");
                    String string2 = httpServletRequest.getParameter("submitcontrol");
                    if (string2 != null) {
                        if (string2.equals("savebutton")) {
                            this.setupInitialValues(string);
                            String string3 = this.usersCommand.modifyUser(this.sb.getUser(), this.sb.getRole());
                            if (string3 == null) {
                                UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_USERS_PAGE), httpServletResponse);
                            } else {
                                HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", string3);
                            }
                            this.displayMasthead();
                            UtilsWeb.include(this.getServletContext(), "/jsp/usersmod.jsp", httpServletRequest, httpServletResponse);
                        } else if (string2.equals("cancelbutton")) {
                            UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_USERS_PAGE), httpServletResponse);
                        }
                    } else {
                        this.setupInitialValues(hashtable);
                        this.displayMasthead();
                        UtilsWeb.include(this.getServletContext(), "/jsp/usersmod.jsp", httpServletRequest, httpServletResponse);
                    }
                }
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            object = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        if (object != null) {
            this.displayMasthead();
            this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.USERS_MOD_PAGE, (Throwable)object));
            this.out.flush();
        }
    }

    public void setupInitialValues(String string) {
        this.sb.setId(this.idValue);
        this.sb.setUser(string);
        this.sb.setRole(this.request.getParameter("roleselect"));
    }

    public void setupInitialValues(Hashtable hashtable) {
        this.sb.setId((String)hashtable.get("ID"));
        this.sb.setUser((String)hashtable.get("User"));
        this.sb.setRole((String)hashtable.get("Role"));
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Administration", "Administration", "Users", NSMPages.getPageHelp(NSMPages.USERS_MOD_PAGE), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.USERS_MOD_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.sb = new UsersBean();
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "This is the main Users Notification page.";
    }
}

