/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.alarms;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.alarms.AlarmsCommand;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AlarmDetails
extends HttpServlet {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.alarms.Localization";
    private static final String ALARM_TYPE = "alarmtype";
    private static final String ALARMS_DELETE_BUTTON_NAME = "alarmsdeletebutton";
    private static final String ALARMS_DELETE_BUTTON_TEXT = "alarms_delete_one_button";
    private static final TableColumn[] COLUMNS = new TableColumn[]{new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "property"), false, "\"left\""), new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "value"), false, "\"left\"")};
    public static final int COLUMN_NUMBER = COLUMNS.length;
    private AlarmsCommand alarmsCommand = null;
    private String alarmType = "";
    private String helpTitle = "";
    private String breadcrumbTitle = "";
    private String tableTitle;
    private String noAlarmsText;
    private String mastheadSubSection;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private String PAGE_URL;
    private String alarmID;
    private boolean deleteEnabled;

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        try {
            object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.ALARMS_DOWN_DETAIL_PAGE));
            if (object == null) {
                return;
            }
            this.deleteEnabled = true;
            if (((String)object).equalsIgnoreCase("Guest")) {
                this.deleteEnabled = false;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        object = null;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.out = httpServletResponse.getWriter();
        this.PAGE_URL = httpServletRequest.getRequestURI();
        if (httpServletRequest.getQueryString() != null) {
            this.PAGE_URL = this.PAGE_URL + "?" + httpServletRequest.getQueryString();
        }
        try {
            String[] stringArray;
            UtilsWeb.noCacheHeader(httpServletResponse);
            this.alarmType = httpServletRequest.getParameter(ALARM_TYPE);
            this.alarmType = this.alarmType == null ? "all" : this.alarmType;
            this.alarmID = httpServletRequest.getParameter("id");
            if (this.alarmID == null) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "alarm_details_msg_no_id"));
                UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ALARMS_PAGE), httpServletResponse);
            }
            if (!this.setPageTitleFields(this.alarmType)) {
                HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "alarm_details_msg_invalid_type"));
                UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ALARMS_PAGE), httpServletResponse);
            }
            this.alarmsCommand = new AlarmsCommand();
            this.alarmsCommand.run();
            String string = httpServletRequest.getParameter("submitcontrol");
            if (string != null && string.equals(ALARMS_DELETE_BUTTON_NAME)) {
                stringArray = httpServletRequest.getParameterValues("id");
                boolean bl = true;
                int n = 0;
                while (n < stringArray.length) {
                    if (!this.alarmsCommand.deleteAlarm(stringArray[n])) {
                        bl = false;
                    }
                    ++n;
                }
                if (bl) {
                    UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ALARMS_PAGE), httpServletResponse);
                } else {
                    HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "del_alarms_msg_failed"));
                }
            }
            this.displayMasthead();
            stringArray = this.getAlarmDetailsTable(this.alarmID);
            this.out.println(HTMLTags.getContentStartTags(this.PAGE_URL));
            this.out.println(HTMLTags.getContentSubSectionTags("\"right\""));
            if (this.deleteEnabled) {
                this.out.println(HTMLTags.getSubmitButtonTag(ALARMS_DELETE_BUTTON_NAME, Localization.getString(BUNDLE, ALARMS_DELETE_BUTTON_TEXT)));
            }
            if (stringArray != null) {
                if (stringArray.equals("")) {
                    this.out.println(HTMLTags.getInfoBoxTag(Localization.getString(BUNDLE, this.noAlarmsText)));
                } else {
                    this.out.println((String)stringArray);
                }
            }
            this.out.println(HTMLTags.getContentEndTags());
            this.out.flush();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            object = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        if (object != null) {
            this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, this.breadcrumbTitle, (Throwable)object));
            this.out.flush();
        }
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Alarms", "Alarms", this.mastheadSubSection, NSMPages.getPageHelp(this.helpTitle), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, this.breadcrumbTitle));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    private boolean setPageTitleFields(String string) {
        boolean bl = true;
        if (string.equals("down")) {
            this.mastheadSubSection = "Down";
            this.helpTitle = NSMPages.ALARMS_DOWN_DETAIL_PAGE;
            this.breadcrumbTitle = NSMPages.ALARMS_DOWN_DETAIL_PAGE;
            this.tableTitle = Localization.getString(BUNDLE, "alarm_details_table_header_label_down");
            this.noAlarmsText = "alarm_details_msg_invalid_id";
        } else if (string.equals("critical")) {
            this.mastheadSubSection = "Critical";
            this.helpTitle = NSMPages.ALARMS_CRITICAL_DETAIL_PAGE;
            this.breadcrumbTitle = NSMPages.ALARMS_CRITICAL_DETAIL_PAGE;
            this.tableTitle = Localization.getString(BUNDLE, "alarm_details_table_header_label_critical");
            this.noAlarmsText = "alarm_details_msg_invalid_id";
        } else if (string.equals("major")) {
            this.mastheadSubSection = "Major";
            this.helpTitle = NSMPages.ALARMS_MAJOR_DETAIL_PAGE;
            this.breadcrumbTitle = NSMPages.ALARMS_MAJOR_DETAIL_PAGE;
            this.tableTitle = Localization.getString(BUNDLE, "alarm_details_table_header_label_major");
            this.noAlarmsText = "alarm_details_msg_invalid_id";
        } else if (string.equals("minor")) {
            this.mastheadSubSection = "Minor";
            this.helpTitle = NSMPages.ALARMS_MINOR_DETAIL_PAGE;
            this.breadcrumbTitle = NSMPages.ALARMS_MINOR_DETAIL_PAGE;
            this.tableTitle = Localization.getString(BUNDLE, "alarm_details_table_header_label_minor");
            this.noAlarmsText = "alarm_details_msg_invalid_id";
        } else {
            bl = false;
        }
        this.tableTitle = "<IMG src=\"/nsm/images/icons/" + Localization.getString(BUNDLE, "level_icon_14_" + string) + "\" width=\"14\" height=\"14\" border=\"0\" alt=\"" + Localization.getString(BUNDLE, "level_icon_text_" + string) + "\"> " + this.tableTitle;
        return bl;
    }

    public String getAlarmDetailsTable(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.alarmsCommand.count() != 0 && string != null) {
            String[] stringArray = this.alarmsCommand.getAlarm(string);
            int n = stringArray.length - 1;
            HTMLTags.TableInfo tableInfo = HTMLTags.getTableInfo(this.request, 0, n);
            String[][] stringArray2 = new String[n][2];
            stringArray2[0][0] = Localization.getString(BUNDLE, "details_description");
            stringArray2[1][0] = Localization.getString(BUNDLE, "details_time");
            stringArray2[2][0] = Localization.getString(BUNDLE, "details_details");
            stringArray2[0][1] = stringArray[1];
            stringArray2[1][1] = new Date(Long.parseLong(stringArray[2])).toString();
            stringArray2[2][1] = stringArray[3];
            stringBuffer.append(HTMLTags.getContentSubSectionTags("\"left\""));
            stringBuffer.append(HTMLTags.getTableTitleTag(this.tableTitle));
            stringBuffer.append(HTMLTags.getTableTag(this.PAGE_URL, COLUMNS, stringArray2, tableInfo.sortColumn, tableInfo.firstRow, n, tableInfo.pageSize));
        }
        return stringBuffer.toString();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "The page for displaying alarms.";
    }
}

