/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.alarms;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.admin.AttributeCommand;
import com.sun.netstorage.mgmt.nsmui.alarms.AlarmsCommand;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.SeverityColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Alarms
extends HttpServlet {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.alarms.Localization";
    private static final String ALARM_TYPE = "alarmtype";
    private static final String ALARMS_DELETE_BUTTON_TEXT = "delete_button_label";
    private static final TableColumn[] COLUMNS = new TableColumn[]{new TableColumn(HTMLTags.getSelectionButtonsTag("id"), false, "\"center\""), new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "severity"), true, "\"left\""), new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "description"), true, "\"left\""), new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "time"), true, "\"left\"")};
    public static final int COLUMN_NUMBER = COLUMNS.length;
    public static final int DEFAULT_SORT_COLUMN = -2;
    private static final int ID_COLUMN = 0;
    private static final int LEVEL_COLUMN = 1;
    private static final int DESCRIPTION_COLUMN = 2;
    private static final int TIME_COLUMN = 3;
    private String[] buttonItems = new String[]{"delete_button_label"};
    private boolean[] buttonsOff = new boolean[]{false};
    private boolean[] buttonsOn = new boolean[]{true};
    private AlarmsCommand alarmsCommand = null;
    private String alarmType = "";
    private String helpTitle = NSMPages.ALARMS_PAGE;
    private String breadcrumbTitle = NSMPages.ALARMS_PAGE;
    private String tableTitle;
    private String noAlarmsText;
    private String mastheadSubSection;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private String PAGE_URL;
    private boolean deleteEnabled;

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        boolean bl;
        Object object;
        block21: {
            UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
            try {
                object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.ALARMS_PAGE));
                if (object == null) {
                    return;
                }
                this.deleteEnabled = true;
                if (((String)object).equalsIgnoreCase("Guest")) {
                    this.deleteEnabled = false;
                }
            }
            catch (LoginException loginException) {
                return;
            }
            object = null;
            this.request = httpServletRequest;
            this.response = httpServletResponse;
            this.out = httpServletResponse.getWriter();
            this.PAGE_URL = HTMLTags.createURL(httpServletRequest.getRequestURI(), httpServletRequest.getQueryString());
            this.getServletContext().removeAttribute("deleteCandidates");
            bl = false;
            try {
                Object object2;
                UtilsWeb.noCacheHeader(httpServletResponse);
                this.alarmType = httpServletRequest.getParameter(ALARM_TYPE);
                this.alarmType = this.alarmType == null ? "all" : this.alarmType;
                this.setPageTitleFields(this.alarmType);
                this.alarmsCommand = new AlarmsCommand();
                this.alarmsCommand.run();
                String string = httpServletRequest.getParameter("submitcontrol");
                if (string != null && string.equals(ALARMS_DELETE_BUTTON_TEXT)) {
                    String[] stringArray = httpServletRequest.getParameterValues("id");
                    if (stringArray != null) {
                        this.getServletContext().setAttribute("deleteCandidates", (Object)stringArray);
                        UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ALARMS_DEL_PAGE), httpServletResponse);
                        bl = true;
                    } else {
                        HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "del_alarms_none_checked"));
                    }
                }
                if (bl) break block21;
                int n = this.alarmsCommand.getNumberOfAlarms(this.alarmType);
                if (n == 1) {
                    String[][] stringArray = this.alarmsCommand.getAlarms(this.alarmType);
                    String string2 = httpServletRequest.getQueryString();
                    if (httpServletRequest.getQueryString() == null) {
                        string2 = "alarmtype=" + Utils.mapSeverityToToken(stringArray[0][1]);
                    }
                    String string3 = "?" + string2 + "&id=" + URLEncoder.encode(stringArray[0][0]);
                    UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ALARMS_DOWN_DETAIL_PAGE) + string3, httpServletResponse);
                    break block21;
                }
                this.displayMasthead();
                this.out.println(HTMLTags.getContentStartTags(this.PAGE_URL));
                String string4 = null;
                try {
                    object2 = new AttributeCommand();
                    ((AttributeCommand)object2).run();
                    string4 = ((AttributeCommand)object2).getAttribute("sade");
                    if (string4 != null && string4.length() != 0) {
                        string4 = string4 + Localization.getString("com.sun.netstorage.mgmt.nsmui.launch.Localization", "sadeAlarmJSP");
                        String string5 = httpServletRequest.getParameter(ALARM_TYPE);
                        if (string5 != null) {
                            string4 = HTMLTags.modifyURLParameter(string4, Localization.getString("com.sun.netstorage.mgmt.nsmui.launch.Localization", "sadeSeverityParam"), string5);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.out.println(HTMLTags.getContentSubSectionTags("\"right\""));
                if (string4 == null || string4.equals("")) {
                    this.out.println(HTMLTags.getDisabledButtonTag(Localization.getString(BUNDLE, "healthButton")));
                } else {
                    this.out.println(HTMLTags.getLinkTargetButtonTag(string4, Localization.getString(BUNDLE, "healthButton"), "sade"));
                }
                this.out.println(HTMLTags.getContentSubSectionTags("\"left\"", 16));
                object2 = this.getAlarmsTable(this.alarmType);
                this.out.println((String)object2);
                this.out.println(HTMLTags.getContentEndTags());
                this.out.close();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                if (throwable instanceof NSMUIException) {
                    throwable.printStackTrace();
                    object = (NSMUIException)throwable;
                }
                throwable.printStackTrace();
                object = new NSMUIException("", throwable);
            }
        }
        if (!bl) {
            this.displayMasthead();
            if (object != null) {
                this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.ALARMS_PAGE, (Throwable)object));
                this.out.flush();
            }
        }
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Alarms", "Alarms", this.mastheadSubSection, NSMPages.getPageHelp(this.helpTitle), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, this.breadcrumbTitle));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    private void setPageTitleFields(String string) {
        if (string.equals("down")) {
            this.mastheadSubSection = "Down";
            this.helpTitle = NSMPages.ALARMS_DOWN_PAGE;
            this.breadcrumbTitle = NSMPages.ALARMS_DOWN_PAGE;
            this.tableTitle = "table_header_label_down";
            this.noAlarmsText = "no_alarms_down";
        } else if (string.equals("critical")) {
            this.mastheadSubSection = "Critical";
            this.helpTitle = NSMPages.ALARMS_CRITICAL_PAGE;
            this.breadcrumbTitle = NSMPages.ALARMS_CRITICAL_PAGE;
            this.tableTitle = "table_header_label_critical";
            this.noAlarmsText = "no_alarms_critical";
        } else if (string.equals("major")) {
            this.mastheadSubSection = "Major";
            this.helpTitle = NSMPages.ALARMS_MAJOR_PAGE;
            this.breadcrumbTitle = NSMPages.ALARMS_MAJOR_PAGE;
            this.tableTitle = "table_header_label_major";
            this.noAlarmsText = "no_alarms_major";
        } else if (string.equals("minor")) {
            this.mastheadSubSection = "Minor";
            this.helpTitle = NSMPages.ALARMS_MINOR_PAGE;
            this.breadcrumbTitle = NSMPages.ALARMS_MINOR_PAGE;
            this.tableTitle = "table_header_label_minor";
            this.noAlarmsText = "no_alarms_minor";
        } else {
            this.mastheadSubSection = "All";
            this.helpTitle = NSMPages.ALARMS_PAGE;
            this.breadcrumbTitle = NSMPages.ALARMS_PAGE;
            this.tableTitle = "table_header_label_all";
            this.noAlarmsText = "no_alarms_all";
        }
    }

    public String getAlarmsTable(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[][] stringArray = this.alarmsCommand.getAlarms(string);
        int n = stringArray.length;
        HTMLTags.TableInfo tableInfo = HTMLTags.getTableInfo(this.request, -2, n);
        int n2 = tableInfo.sortColumn;
        int n3 = tableInfo.firstRow;
        int n4 = tableInfo.pageSize;
        int n5 = Math.abs(tableInfo.sortColumn) - 1;
        if (n5 == 1) {
            Arrays.sort(stringArray, new SeverityColumnComparator(n2));
        } else {
            Arrays.sort(stringArray, new SmartColumnComparator(n2));
        }
        int n6 = Math.min(n4, n - n3);
        String[][] stringArray2 = new String[n6][];
        System.arraycopy(stringArray, n3, stringArray2, 0, n6);
        if (this.alarmsCommand.getNumberOfAlarms(string) != 0) {
            int n7 = 0;
            while (n7 < n6) {
                String string2 = NSMPages.getPageURL(NSMPages.ALARMS_DOWN_DETAIL_PAGE) + "?alarmtype=" + Utils.mapSeverityToToken(stringArray2[n7][1]) + "&id=" + URLEncoder.encode(stringArray2[n7][0]);
                stringArray2[n7][2] = HTMLTags.getLinkTag(string2, stringArray2[n7][2]);
                ++n7;
            }
            int n8 = 0;
            while (n8 < n6) {
                stringArray2[n8][1] = Alarms.getLevel(stringArray2[n8][1]);
                ++n8;
            }
            int n9 = 0;
            while (n9 < n6) {
                Date date = new Date(Long.parseLong(stringArray2[n9][3]));
                stringArray2[n9][3] = DateFormat.getDateTimeInstance(2, 3).format(date) + "  ";
                ++n9;
            }
            int n10 = 0;
            while (n10 < n6) {
                stringArray2[n10][0] = HTMLTags.getInputCheckboxTag("id", stringArray2[n10][0], false);
                ++n10;
            }
        }
        if (n <= n4) {
            stringBuffer.append(HTMLTags.getTableTitleTag(Localization.getString(BUNDLE, this.tableTitle)));
        } else {
            stringBuffer.append(HTMLTags.getTableTitleTag(Localization.getString(BUNDLE, this.tableTitle), n3, n, n4));
        }
        stringBuffer.append(HTMLTags.getContentSubSectionTags("\"left\""));
        if (this.deleteEnabled) {
            if (n == 0) {
                stringBuffer.append(HTMLTags.getActionButtonsTag(BUNDLE, "actionMenuTitle", this.buttonItems, this.buttonsOff));
            } else {
                stringBuffer.append(HTMLTags.getActionButtonsTag(BUNDLE, "actionMenuTitle", this.buttonItems, this.buttonsOn));
            }
        }
        stringBuffer.append(HTMLTags.getTableTag(this.PAGE_URL, COLUMNS, stringArray2, n2, n3, n, n4));
        return stringBuffer.toString();
    }

    public static String getLevel(String string) {
        String string2 = Utils.mapSeverityToToken(string);
        return "<IMG src=\"/nsm/images/icons/" + Localization.getString(BUNDLE, "level_icon_14_" + string2) + "\" width=\"14\" height=\"14\" border=\"0\" alt=\"" + Localization.getString(BUNDLE, "level_icon_text_" + string2) + "\">&nbsp;" + Localization.getString(BUNDLE, "severity_level_" + string2);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "The page for displaying alarms.";
    }
}

