/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.alarms;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.Configuration;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.service.alarm.AlarmService;
import com.sun.netstorage.mgmt.service.event.AbstractEvent;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

public class AlarmsCommand {
    private static int COLUMNS = 4;
    private static String BUNDLE = "com.sun.netstorage.mgmt.nsmui.alarms.Localization";
    private AlarmService aService = null;
    protected Hashtable theAlarms = null;
    private AbstractEvent[] alarmEvents;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$service$alarm$AlarmService;

    public AlarmsCommand() throws NSMUIException {
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new SecurityManager());
            }
            String string = Configuration.getProperty("REGISTRY_HOST");
            Registry registry = null;
            try {
                registry = LocateRegistry.getRegistry(string, Integer.parseInt(Configuration.getProperty("NSM_RMI_REGISTRY_PORT")));
            }
            catch (NumberFormatException numberFormatException) {
                registry = LocateRegistry.getRegistry(string);
            }
            this.aService = (AlarmService)registry.lookup((class$com$sun$netstorage$mgmt$service$alarm$AlarmService == null ? (class$com$sun$netstorage$mgmt$service$alarm$AlarmService = AlarmsCommand.class$("com.sun.netstorage.mgmt.service.alarm.AlarmService")) : class$com$sun$netstorage$mgmt$service$alarm$AlarmService).getPackage().getName());
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
    }

    public void run() throws NSMUIException {
        try {
            this.alarmEvents = this.aService.getAlarms(0, Integer.MAX_VALUE);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
    }

    public int count() {
        if (this.alarmEvents == null) {
            return 0;
        }
        return this.alarmEvents.length;
    }

    public String[][] getAlarms() {
        return this.getAlarms("all");
    }

    public String[][] getAlarms(String string) {
        int n = this.getNumberOfAlarms(string);
        String[][] stringArray = new String[n][COLUMNS];
        if (n == 0) {
            return new String[0][];
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.alarmEvents.length) {
            String string2 = String.valueOf(this.alarmEvents[n3].getSeverity());
            if (string.equals("all") || Utils.mapSeverityToToken(string2).equals(string)) {
                stringArray[n2][0] = this.alarmEvents[n3].getSource() + "#" + String.valueOf(this.alarmEvents[n3].getSourceSequenceNumber());
                stringArray[n2][1] = String.valueOf(this.alarmEvents[n3].getSeverity());
                stringArray[n2][2] = this.alarmEvents[n3].getTerse(Locale.getDefault());
                stringArray[n2][3] = String.valueOf(this.alarmEvents[n3].getSourceTime());
                ++n2;
            }
            ++n3;
        }
        return stringArray;
    }

    public String getFullAlarmID(String string) {
        String[] stringArray = new String[COLUMNS];
        String string2 = null;
        long l = 0L;
        if (string.indexOf("#") > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
            if (stringTokenizer.countTokens() == 2) {
                string2 = (String)stringTokenizer.nextElement();
                l = Long.parseLong((String)stringTokenizer.nextElement());
            }
        } else {
            l = Long.parseLong(string);
        }
        int n = 0;
        while (n < this.alarmEvents.length) {
            if ((string2 == null || this.alarmEvents[n].getSource().equals(string2)) && this.alarmEvents[n].getSourceSequenceNumber() == l) {
                return this.alarmEvents[n].getSource() + "#" + String.valueOf(this.alarmEvents[n].getSourceSequenceNumber());
            }
            ++n;
        }
        return string;
    }

    public String[] getAlarm(String string) {
        String[] stringArray = new String[COLUMNS];
        String string2 = null;
        long l = 0L;
        if (string.indexOf("#") > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
            if (stringTokenizer.countTokens() == 2) {
                string2 = (String)stringTokenizer.nextElement();
                l = Long.parseLong((String)stringTokenizer.nextElement());
            }
        } else {
            l = Long.parseLong(string);
        }
        int n = 0;
        while (n < this.alarmEvents.length) {
            if ((string2 == null || this.alarmEvents[n].getSource().equals(string2)) && this.alarmEvents[n].getSourceSequenceNumber() == l) {
                stringArray[0] = String.valueOf(this.alarmEvents[n].getSeverity());
                stringArray[1] = this.alarmEvents[n].getTerse(Locale.getDefault());
                stringArray[2] = String.valueOf(this.alarmEvents[n].getSourceTime());
                stringArray[3] = this.alarmEvents[n].getVerbose(Locale.getDefault());
            }
            ++n;
        }
        if (stringArray == null) {
            return null;
        }
        return stringArray;
    }

    public boolean deleteAlarm(String string) throws NSMUIException {
        boolean bl = false;
        String string2 = "";
        long l = 0L;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
            if (stringTokenizer.countTokens() == 2) {
                string2 = (String)stringTokenizer.nextElement();
                l = Long.parseLong((String)stringTokenizer.nextElement());
            }
            bl = this.aService.clearAlarm(new AlarmService.AlarmID(string2, l));
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
        return bl;
    }

    public int getNumberOfAlarms(String string) {
        int n = this.alarmEvents.length;
        if (!string.equals("all")) {
            n = 0;
            int n2 = 0;
            while (n2 < this.alarmEvents.length) {
                String string2 = String.valueOf(this.alarmEvents[n2].getSeverity());
                if (Utils.mapSeverityToToken(string2).equals(string)) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    public long getExpirationTime() throws NSMUIException {
        long l = 0L;
        try {
            l = this.aService.getAlarmExpiration();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
        return l;
    }

    public void setExpirationTime(long l) throws NSMUIException {
        try {
            this.aService.setAlarmExpiration(l);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
    }

    static void main(String[] stringArray) throws Exception {
        String string = null;
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        AlarmsCommand alarmsCommand = new AlarmsCommand();
        alarmsCommand.run();
        String[][] stringArray2 = alarmsCommand.getAlarms();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray2.length) {
            int n2 = 0;
            while (n2 < stringArray2[0].length) {
                stringBuffer.append(stringArray2[n][n2] + "        ");
                ++n2;
            }
            System.out.println(stringBuffer);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

