/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.alarms;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.alarms.Alarms;
import com.sun.netstorage.mgmt.nsmui.alarms.AlarmsCommand;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.SeverityColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AlarmsDel
extends HttpServlet {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.alarms.Localization";
    private static final String ALARM_TYPE = "alarmtype";
    private static final TableColumn[] COLUMNS = new TableColumn[]{new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "severity"), true, "\"left\""), new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "description"), true, "\"left\""), new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "time"), true, "\"left\"")};
    public static final int COLUMN_NUMBER = COLUMNS.length;
    public static final int DEFAULT_SORT_COLUMN = -1;
    private static final int LEVEL_COLUMN = 0;
    private static final int DESCRIPTION_COLUMN = 1;
    private static final int TIME_COLUMN = 2;
    private AlarmsCommand alarmsCommand = null;
    private String alarmTable;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private String PAGE_URL;

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        try {
            object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.ALARMS_PAGE));
            if (object == null || ((String)object).equalsIgnoreCase("Guest")) {
                return;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        object = null;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.out = httpServletResponse.getWriter();
        this.PAGE_URL = httpServletRequest.getRequestURI();
        httpServletRequest.setAttribute("AlarmsDelId", (Object)this);
        try {
            String[] stringArray = (String[])this.getServletContext().getAttribute("deleteCandidates");
            String string = httpServletRequest.getParameter("submitcontrol");
            if (string != null && string.equals("alarmsdeletebutton")) {
                if (stringArray != null) {
                    boolean bl = true;
                    int n = 0;
                    while (n < stringArray.length) {
                        if (!this.alarmsCommand.deleteAlarm(stringArray[n])) {
                            bl = false;
                        }
                        ++n;
                    }
                    if (!bl) {
                        HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "del_alarms_msg_failed"));
                    }
                    UtilsWeb.redirect(NSMPages.ALARMS_PAGE, httpServletResponse);
                } else {
                    HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "del_alarms_none_checked"));
                    UtilsWeb.redirect(NSMPages.ALARMS_PAGE, httpServletResponse);
                }
            } else if (stringArray != null) {
                this.alarmsCommand = new AlarmsCommand();
                this.alarmsCommand.run();
                HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "del_alarms_msg_are_you_sure"));
                this.displayMasthead();
                this.alarmTable = this.buildAlarmsTable(stringArray);
                UtilsWeb.include(this.getServletContext(), "/jsp/alarmsdel.jsp", httpServletRequest, httpServletResponse);
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            if (throwable instanceof NSMUIException) {
                throwable.printStackTrace();
                object = (NSMUIException)throwable;
            }
            throwable.printStackTrace();
            object = new NSMUIException("", throwable);
        }
        if (object != null) {
            this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.ALARMS_DEL_PAGE, (Throwable)object));
            this.out.flush();
        }
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Alarms", "Alarms", NSMPages.ALARMS_DEL_PAGE, NSMPages.getPageHelp(NSMPages.ALARMS_DEL_PAGE), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.ALARMS_DEL_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    public String getAlarmsTable() {
        return this.alarmTable;
    }

    public String getCancelButton() {
        return HTMLTags.getCancelButtonTag();
    }

    public String getDeleteButton() {
        return HTMLTags.getSubmitButtonTag("alarmsdeletebutton", Localization.getString(BUNDLE, "delete_button_label"));
    }

    private String buildAlarmsTable(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length != 0) {
            String[][] stringArray2 = new String[stringArray.length][COLUMN_NUMBER];
            int n = 0;
            while (n < stringArray.length) {
                String[] stringArray3 = this.alarmsCommand.getAlarm(stringArray[n]);
                stringArray2[n][0] = stringArray3[0];
                stringArray2[n][1] = stringArray3[1];
                stringArray2[n][2] = stringArray3[2];
                ++n;
            }
            int n2 = stringArray2.length;
            HTMLTags.TableInfo tableInfo = HTMLTags.getTableInfo(this.request, -1, n2);
            int n3 = tableInfo.sortColumn;
            int n4 = tableInfo.firstRow;
            int n5 = n2;
            int n6 = Math.abs(tableInfo.sortColumn) - 1;
            if (n6 == 0) {
                Arrays.sort(stringArray2, new SeverityColumnComparator(n3));
            } else {
                Arrays.sort(stringArray2, new SmartColumnComparator(n3));
            }
            int n7 = Math.min(n5, n2 - n4);
            String[][] stringArray4 = new String[n7][];
            System.arraycopy(stringArray2, n4, stringArray4, 0, n7);
            int n8 = 0;
            while (n8 < n7) {
                stringArray4[n8][0] = Alarms.getLevel(stringArray4[n8][0]);
                ++n8;
            }
            int n9 = 0;
            while (n9 < n7) {
                Date date = new Date(Long.parseLong(stringArray4[n9][2]));
                stringArray4[n9][2] = DateFormat.getDateTimeInstance(2, 3).format(date) + "  ";
                ++n9;
            }
            stringBuffer.append(HTMLTags.getTableTag(this.PAGE_URL, COLUMNS, stringArray4, n3, n4, n2, n5));
        }
        return stringBuffer.toString();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "The page for deleting alarms.";
    }
}

