/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.common.clip.StatementOption;
import com.sun.netstorage.mgmt.nsmui.admin.IPAdminCommand;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;

public class AddAddressCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.AddAddressCLI";
    private static final CommandOption[] OPTIONS = new CommandOption[]{CommandOption.newOption('u', "username", true), CommandOption.newOption('p', "password", false)};

    public AddAddressCLICommand() {
        super(BUNDLE, "AddAddress", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Object[] objectArray;
        Utils.cliSecurityCheck("Admin");
        StatementOption statementOption = statement.getOption('u');
        String string = null;
        if (statementOption == null) {
            throw new StatementException(Localization.getString(BUNDLE, "addresses_no_user"));
        }
        string = statementOption.getArgument();
        statementOption = statement.getOption('p');
        String string2 = "";
        if (statementOption != null) {
            string2 = statementOption.getArgument();
        }
        if ((objectArray = statement.getOperands()) == null || objectArray.length == 0) {
            throw new StatementException(Localization.getString(BUNDLE, "addresses_no_address"));
        }
        try {
            IPAdminCommand iPAdminCommand = new IPAdminCommand();
            iPAdminCommand.run();
            String string3 = iPAdminCommand.getUsername(objectArray[0]);
            if (string3 != null) {
                throw new StatementException(Localization.getString(BUNDLE, "addresses_duplicate_error", objectArray));
            }
            iPAdminCommand.setAgentKey(objectArray[0], string, string2);
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "addresses_write_error"), 99);
        }
    }
}

