/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.common.clip.StatementOption;
import com.sun.netstorage.mgmt.nsmui.admin.UsersCommand;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;

public class AddUserCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.AddUserCLI";
    private static final String ADMIN_BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private static final CommandOption[] OPTIONS = new CommandOption[]{CommandOption.newOption('r', "role", false)};

    public AddUserCLICommand() {
        super(BUNDLE, "AddUser", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        String[] stringArray;
        Utils.cliSecurityCheck("Admin");
        StatementOption statementOption = statement.getOption('r');
        String string = "Guest";
        if (statementOption != null) {
            string = statementOption.getArgument();
            if (string.equalsIgnoreCase("Guest") || string.equalsIgnoreCase("Operator") || string.equalsIgnoreCase("Admin")) {
                string = Localization.getString(ADMIN_BUNDLE, string);
            } else {
                throw new StatementException(Localization.getString(BUNDLE, "add_user_invalid_role"));
            }
        }
        if ((stringArray = statement.getOperands()) == null || stringArray.length == 0) {
            throw new StatementException(Localization.getString(BUNDLE, "add_user_no_username"));
        }
        try {
            UsersCommand usersCommand = new UsersCommand();
            usersCommand.run();
            if (usersCommand.getUser(stringArray[0]) != null) {
                throw new StatementException(Localization.getString(BUNDLE, "add_user_existing_user", stringArray[0]));
            }
            usersCommand.addUser(stringArray[0], string);
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "add_user_add_error"), 99);
        }
    }
}

