/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.common.clip.StatementOption;
import com.sun.netstorage.mgmt.nsmui.admin.IPAdminCommand;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;
import java.util.Arrays;

public class AddressesCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.AddressesCLI";
    private static final String ADMIN_BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private static final int DEFAULT_SORT_COL = 2;
    private static final TableColumn[] COLUMNS = new TableColumn[3];
    private static final int ID_COLUMN = 0;
    private static final int IP_COLUMN = 1;
    private static final int USER_COLUMN = 2;
    private static final CommandOption[] OPTIONS = new CommandOption[]{CommandOption.newOption('s', "sort", false), CommandOption.newOption('r', "reverse", false)};

    public AddressesCLICommand() {
        super(BUNDLE, "Addresses", OPTIONS);
        if (COLUMNS[0] == null) {
            AddressesCLICommand.COLUMNS[0] = null;
            AddressesCLICommand.COLUMNS[1] = new TableColumn(Localization.getString(ADMIN_BUNDLE, "ips_table_title_ips"), true, "\"left\"");
            AddressesCLICommand.COLUMNS[2] = new TableColumn(Localization.getString(ADMIN_BUNDLE, "ips_table_title_user"), true, "\"left\"");
        }
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Admin");
        try {
            IPAdminCommand iPAdminCommand = new IPAdminCommand();
            iPAdminCommand.run();
            int n = 2;
            StatementOption statementOption = statement.getOption('s');
            if (statementOption != null) {
                n = new Integer(statementOption.getArgument()) + 1;
            }
            if ((statementOption = statement.getOption('r')) != null) {
                n = new Integer("-" + statementOption.getArgument()) - 1;
            }
            String[][] stringArray = iPAdminCommand.getKeyInfo();
            Arrays.sort(stringArray, new SmartColumnComparator(n));
            CLIUtils.printTable(printWriter, COLUMNS, stringArray);
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "addresses_retrieval_error"), 99);
        }
    }
}

