/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.common.clip.StatementOption;
import com.sun.netstorage.mgmt.nsmui.alarms.AlarmsCommand;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;

public class AlarmsCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.AlarmsCLI";
    private static final String ALARMS_BUNDLE = "com.sun.netstorage.mgmt.nsmui.alarms.Localization";
    private static final int DEFAULT_SORT_COL = -2;
    private static final TableColumn[] COLUMNS = new TableColumn[]{new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "id"), false, "\"left\""), new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "severity"), false, "\"left\""), new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "description"), false, "\"left\""), new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "time"), false, "\"left\"")};
    private static final int ID_COLUMN = 0;
    private static final int LEVEL_COLUMN = 1;
    private static final int DESCRIPTION_COLUMN = 2;
    private static final int TIME_COLUMN = 3;
    private AlarmsCommand alarmsCommand = null;
    private static final CommandOption[] OPTIONS = new CommandOption[]{CommandOption.newOption('s', "sort", false), CommandOption.newOption('r', "reverse", false)};

    public AlarmsCLICommand() {
        super(BUNDLE, "Alarms", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Guest");
        try {
            AlarmsCommand alarmsCommand = new AlarmsCommand();
            alarmsCommand.run();
            int n = -2;
            StatementOption statementOption = statement.getOption('s');
            if (statementOption != null) {
                n = new Integer(statementOption.getArgument());
            }
            if ((statementOption = statement.getOption('r')) != null) {
                n = new Integer("-" + statementOption.getArgument());
            }
            String[][] stringArray = alarmsCommand.getAlarms();
            Arrays.sort(stringArray, new SmartColumnComparator(n));
            if (stringArray.length != 0 && stringArray[0].length != 0) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    stringArray[n2][0] = stringArray[n2][0].substring(stringArray[n2][0].indexOf("#") + 1);
                    stringArray[n2][1] = Localization.getString(ALARMS_BUNDLE, "severity_level_" + Utils.mapSeverityToToken(stringArray[n2][1]));
                    stringArray[n2][3] = new Date(Long.parseLong(stringArray[n2][3])).toString();
                    ++n2;
                }
                CLIUtils.printTable(printWriter, COLUMNS, stringArray);
            } else {
                printWriter.println(Localization.getString(ALARMS_BUNDLE, "no_alarms_all"));
            }
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "alarms_retrieval_error"), 99);
        }
    }
}

