/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.nsmui.admin.AttributeCommand;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class ApplicationsCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.ApplicationsCLI";
    private static final String ADMIN_BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private static final int DEFAULT_SORT_COL = -2;
    private static final int NUMBER_OF_COLUMNS = 2;
    private static final TableColumn[] COLUMNS = new TableColumn[2];
    private static final int NAME_COLUMN = 0;
    private static final int URL_COLUMN = 1;
    private AttributeCommand attributeCommand;
    private static final CommandOption[] OPTIONS = new CommandOption[0];

    public ApplicationsCLICommand() {
        super(BUNDLE, "Applications", OPTIONS);
        if (COLUMNS[0] == null) {
            ApplicationsCLICommand.COLUMNS[0] = new TableColumn(Localization.getString(ADMIN_BUNDLE, "app_table_title_name"), false, "\"left\"");
            ApplicationsCLICommand.COLUMNS[1] = new TableColumn(Localization.getString(ADMIN_BUNDLE, "app_table_title_url"), false, "\"left\"");
        }
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Admin");
        try {
            this.attributeCommand = new AttributeCommand();
            this.attributeCommand.run();
            StringTokenizer stringTokenizer = new StringTokenizer(Localization.getString(ADMIN_BUNDLE, "configurable_applications"), " ");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                stringArray[n] = (String)stringTokenizer.nextElement();
                ++n;
            }
            int n2 = stringArray.length;
            String[][] stringArray2 = new String[n2][2];
            n = 0;
            while (n < n2) {
                stringArray2[n][0] = Localization.getString(ADMIN_BUNDLE, stringArray[n]) + " (" + Localization.getString(ADMIN_BUNDLE, stringArray[n] + ".cli") + ")";
                stringArray2[n][1] = this.attributeCommand.getAttribute(stringArray[n]);
                ++n;
            }
            CLIUtils.printTable(printWriter, COLUMNS, stringArray2);
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException.getCause(), Localization.getString(BUNDLE, "app_retrieval_error"), 99);
        }
    }
}

