/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyDetailCommand;
import com.sun.netstorage.mgmt.nsmui.topology.ZoneUtil;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyElementNotFoundException;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import com.sun.netstorage.mgmt.services.topology.TopologyPredicate;
import com.sun.netstorage.mgmt.services.topology.TopologyServiceImpl;
import com.sun.netstorage.mgmt.services.topology.Zone;
import java.io.PrintWriter;
import java.util.Arrays;

public class ConnectivityCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.ConnectivityCLI";
    private static final String TOPOLOGY_BUNDLE = "com.sun.netstorage.mgmt.nsmui.topology.Localization";
    private static final CommandOption[] OPTIONS = new CommandOption[0];

    public ConnectivityCLICommand() {
        super(BUNDLE, "Connectivity", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        String[] stringArray = statement.getOperands();
        if (stringArray.length < 1 || stringArray.length > 3) {
            throw new StatementException(Localization.getString(BUNDLE, "incorrectOperandCount"));
        }
        this.printConnectivity(printWriter, stringArray[0], stringArray.length > 1 ? stringArray[1] : null, stringArray.length > 2 ? stringArray[2] : null);
    }

    public static SanTopology getSanTopology() throws TopologyElementNotFoundException {
        boolean bl;
        String string = System.getProperty("stubDB");
        if (string != null) {
            return TopologyServiceImpl.getInstance().getSanTopologySim(string);
        }
        boolean bl2 = bl = System.getProperty("debugDB") != null;
        if (bl) {
            return TopologyServiceImpl.getInstance().getSanTopology("", new PrintWriter(System.out, true));
        }
        return TopologyServiceImpl.getInstance().getSanTopology("");
    }

    public void printConnectivity(PrintWriter printWriter, final String string, String string2, String string3) throws CommandException {
        try {
            TopologyGraph topologyGraph;
            Object object;
            TopologyServiceImpl topologyServiceImpl = TopologyServiceImpl.getInstance();
            SanTopology sanTopology = ConnectivityCLICommand.getSanTopology();
            FabricTopology[] fabricTopologyArray = sanTopology.getFabrics();
            TSTopologyNode tSTopologyNode = null;
            int n = 0;
            while (tSTopologyNode == null && n < fabricTopologyArray.length) {
                object = fabricTopologyArray[n].getTopologySubset(new TopologyPredicate(){

                    public boolean execute(TSTopologyNode tSTopologyNode) {
                        return string.equals(tSTopologyNode.getProperty("Name"));
                    }
                });
                if (((TSTopologyNode[])object).length > 0) {
                    tSTopologyNode = object[0];
                }
                ++n;
            }
            if (tSTopologyNode == null) {
                printWriter.println(Localization.getString(BUNDLE, "deviceNotFound", string));
                return;
            }
            object = "";
            FabricTopology fabricTopology = null;
            Zone zone = null;
            if (string2 != null) {
                int n2 = 0;
                while (zone == null && n2 < fabricTopologyArray.length) {
                    if (string3 == null || string3.equals(fabricTopologyArray[n2].getFabricId().getLogicalName())) {
                        zone = fabricTopologyArray[n2].getZone(string2);
                    }
                    if (zone != null) {
                        fabricTopology = fabricTopologyArray[n2];
                        object = fabricTopologyArray[n2].getFabricId().getLogicalName();
                    }
                    ++n2;
                }
                if (zone == null) {
                    printWriter.println(Localization.getString(BUNDLE, "zoneNotFound", string2));
                    return;
                }
            }
            if ((topologyGraph = sanTopology.getConnectivityGraph(tSTopologyNode, true)) == null) {
                printWriter.println(Localization.getString(BUNDLE, "noSANConnectivityFound", string));
                return;
            }
            TopologyDetailCommand topologyDetailCommand = new TopologyDetailCommand(topologyGraph, fabricTopology, zone, false);
            topologyDetailCommand.run();
            if (zone != null) {
                CLIUtils.printDetail(printWriter, new String[]{Localization.getString(BUNDLE, "fabric"), Localization.getString(BUNDLE, "zone")}, new String[]{object, ZoneUtil.localizeZoneName(zone.getName())}, "\"right\"");
                printWriter.println(Localization.getString(TOPOLOGY_BUNDLE, "zoningNote"));
            }
            String[][] stringArray = topologyDetailCommand.getTableData(null);
            Arrays.sort(stringArray, new SmartColumnComparator(1));
            CLIUtils.printTable(printWriter, TopologyDetailCommand.getColumns(), stringArray);
        }
        catch (DataRetrievalException dataRetrievalException) {
            throw new CommandException(dataRetrievalException.getCause() != null ? dataRetrievalException.getCause() : dataRetrievalException, dataRetrievalException.getMessage(), 99);
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getMessage(), 99);
        }
        printWriter.println();
        printWriter.flush();
    }
}

