/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.nsmui.admin.UsersCommand;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;

public class DeleteUserCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.DeleteUserCLI";
    private static final CommandOption[] OPTIONS = new CommandOption[0];

    public DeleteUserCLICommand() {
        super(BUNDLE, "DeleteUser", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Admin");
        String[] stringArray = statement.getOperands();
        if (stringArray == null || stringArray.length == 0) {
            throw new StatementException(Localization.getString(BUNDLE, "del_user_no_username"));
        }
        try {
            UsersCommand usersCommand = new UsersCommand();
            usersCommand.run();
            int n = 0;
            while (n < stringArray.length) {
                if (usersCommand.getUser(stringArray[n]) == null) {
                    throw new StatementException(Localization.getString(BUNDLE, "del_user_no_user", stringArray[n]));
                }
                usersCommand.deleteUser(stringArray[n]);
                printWriter.println(Localization.getString(BUNDLE, "removed"));
                ++n;
            }
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "del_user_add_error"), 99);
        }
    }
}

