/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.component.model.api.gui.GuiPersistenceManager;
import com.sun.netstorage.mgmt.nsmui.discovery.DiscoveryCommand;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;

public class DiscoverCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.DiscoverCLI";
    private static final CommandOption[] OPTIONS = new CommandOption[]{CommandOption.newBooleanOption('l', "last", true)};

    public DiscoverCLICommand() {
        super(BUNDLE, "Discover", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        try {
            DiscoveryCommand discoveryCommand = new DiscoveryCommand();
            boolean bl = statement.getOption('l') != null;
            printWriter.println(Localization.getString(BUNDLE, "update"));
            printWriter.println("\t" + this.getUpdateDate() + "\n");
            if (!bl) {
                discoveryCommand.run();
                printWriter.println(Localization.getString(BUNDLE, "discovery_requested"));
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new CommandException(throwable, null, 99);
        }
    }

    public String getUpdateDate() {
        try {
            GuiPersistenceManager guiPersistenceManager = (GuiPersistenceManager)Utils.getAssetStorage();
            return guiPersistenceManager.getRefreshDate().toString();
        }
        catch (Exception exception) {
            return "unknown";
        }
    }
}

