/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.cli.TopologyCLICommand;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.topology.FabricInventoryCommand;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import java.io.PrintWriter;

public class FabricsCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.FabricsCLI";
    private static final CommandOption[] OPTIONS = new CommandOption[0];

    public FabricsCLICommand() {
        super(BUNDLE, "Fabrics", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        SanTopology sanTopology = null;
        try {
            sanTopology = TopologyCLICommand.getSanTopology();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new CommandException(throwable, Localization.getString(BUNDLE, "exception"), 99);
        }
        if (sanTopology == null || sanTopology.getFabricCount() == 0) {
            printWriter.println(Localization.getString(BUNDLE, "noFabricsFound"));
            return;
        }
        try {
            FabricInventoryCommand fabricInventoryCommand = new FabricInventoryCommand(sanTopology, false);
            fabricInventoryCommand.run();
            CLIUtils.printTable(printWriter, FabricInventoryCommand.getColumns(), fabricInventoryCommand.getTableData(null));
        }
        catch (DataRetrievalException dataRetrievalException) {
            throw new CommandException(dataRetrievalException.getCause() != null ? dataRetrievalException.getCause() : dataRetrievalException, dataRetrievalException.getMessage(), 99);
        }
    }
}

