/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.common.clip.StatementOption;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.notification.SNMPCommand;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.service.notification.ContractSpecificationException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ModifySnmpNotificationCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.ModifySnmpNotificationCLI";
    private static final String NOTIFICATION_BUNDLE = "com.sun.netstorage.mgmt.nsmui.notification.Localization";
    private static final String[] levels = new String[]{"down", "critical", "major", "minor"};
    private static final CommandOption[] OPTIONS = new CommandOption[]{CommandOption.newOption('h', "hostname", false), CommandOption.newOption('p', "port", false), CommandOption.newOption('l', "locale", false)};
    private static final String[] fields = new String[]{Localization.getString("com.sun.netstorage.mgmt.nsmui.notification.Localization", "snmp_table_title_id"), Localization.getString("com.sun.netstorage.mgmt.nsmui.notification.Localization", "snmp_table_title_level"), Localization.getString("com.sun.netstorage.mgmt.nsmui.notification.Localization", "snmp_table_title_hostname"), Localization.getString("com.sun.netstorage.mgmt.nsmui.notification.Localization", "snmp_table_title_port"), Localization.getString("com.sun.netstorage.mgmt.nsmui.notification.Localization", "email_table_title_locale")};
    private String[] data = new String[5];

    public ModifySnmpNotificationCLICommand() {
        super(BUNDLE, "ModifySnmpNotification", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Admin");
        boolean bl = false;
        try {
            SNMPCommand sNMPCommand = new SNMPCommand();
            sNMPCommand.run();
            String[] stringArray = statement.getOperands();
            if (stringArray == null || stringArray.length == 0) {
                throw new StatementException(Localization.getString(BUNDLE, "snmp_notification_no_id"));
            }
            Hashtable hashtable = sNMPCommand.getContract(stringArray[0]);
            if (hashtable == null) {
                throw new StatementException(Localization.getString(BUNDLE, "snmp_notification_unknown_id", stringArray[0]));
            }
            String string = (String)hashtable.get("Hostname");
            String string2 = (String)hashtable.get("Port");
            String string3 = (String)hashtable.get("Locale");
            StatementOption statementOption = statement.getOption('h');
            if (statementOption != null) {
                string = statementOption.getArgument();
                bl = true;
            }
            if ((statementOption = statement.getOption('p')) != null) {
                string2 = statementOption.getArgument();
                bl = true;
            }
            if ((statementOption = statement.getOption('l')) != null) {
                String string4 = Localization.getString(NOTIFICATION_BUNDLE, statementOption.getArgument().toLowerCase());
                StringTokenizer stringTokenizer = new StringTokenizer(Localization.getString(NOTIFICATION_BUNDLE, "snmp_available_locales"), " ");
                String[] stringArray2 = new String[stringTokenizer.countTokens()];
                Object[] objectArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    stringArray2[n] = (String)stringTokenizer.nextElement();
                    objectArray[n] = Localization.getString(NOTIFICATION_BUNDLE, stringArray2[n]);
                    ++n;
                }
                boolean bl2 = false;
                n = 0;
                while (n < stringArray2.length) {
                    if (stringArray2[n].equals(string4)) {
                        string3 = string4;
                        bl2 = true;
                        break;
                    }
                    ++n;
                }
                if (!bl2) {
                    throw new StatementException(Localization.getString(NOTIFICATION_BUNDLE, "snmp_invalid_locale", objectArray));
                }
                bl = true;
            }
            if (bl) {
                sNMPCommand.modContract(stringArray[0], string, string2, string3);
            } else {
                this.data[0] = stringArray[0];
                this.data[1] = Localization.getString(NOTIFICATION_BUNDLE, Utils.mapSeverityToToken((String)hashtable.get("Criteria")));
                this.data[2] = string;
                this.data[3] = string2;
                this.data[4] = Localization.getString(NOTIFICATION_BUNDLE, string3);
                CLIUtils.printDetail(printWriter, fields, this.data);
            }
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException.getCause(), Localization.getString(BUNDLE, "snmp_retrieval_error"), 99);
        }
        catch (ContractSpecificationException contractSpecificationException) {
            throw new CommandException(contractSpecificationException, Localization.getString(BUNDLE, "snmp_retrieval_error"), 99);
        }
    }
}

