/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.common.clip.StatementOption;
import com.sun.netstorage.mgmt.nsmui.admin.UsersCommand;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;
import java.util.Hashtable;

public class ModifyUserCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.ModifyUserCLI";
    private static final String ADMIN_BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private static final CommandOption[] OPTIONS = new CommandOption[]{CommandOption.newOption('r', "role", false)};
    private static final String[] fields = new String[]{Localization.getString("com.sun.netstorage.mgmt.nsmui.admin.Localization", "users_table_title_users"), Localization.getString("com.sun.netstorage.mgmt.nsmui.admin.Localization", "users_table_title_role")};
    private String[] data = new String[2];

    public ModifyUserCLICommand() {
        super(BUNDLE, "ModifyUser", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        block9: {
            String[] stringArray;
            Utils.cliSecurityCheck("Admin");
            StatementOption statementOption = statement.getOption('r');
            String string = "Guest";
            boolean bl = false;
            if (statementOption != null) {
                string = statementOption.getArgument();
                if (string.equalsIgnoreCase("Guest") || string.equalsIgnoreCase("Operator") || string.equalsIgnoreCase("Admin")) {
                    string = Localization.getString(ADMIN_BUNDLE, string);
                    bl = true;
                } else {
                    throw new StatementException(Localization.getString(BUNDLE, "mod_user_invalid_role"));
                }
            }
            if ((stringArray = statement.getOperands()) == null || stringArray.length == 0) {
                throw new StatementException(Localization.getString(BUNDLE, "mod_user_no_username"));
            }
            try {
                UsersCommand usersCommand = new UsersCommand();
                usersCommand.run();
                Hashtable hashtable = usersCommand.getUser(stringArray[0]);
                if (hashtable != null) {
                    if (bl) {
                        usersCommand.addUser(stringArray[0], string);
                    } else {
                        this.data[0] = (String)hashtable.get("User");
                        this.data[1] = (String)hashtable.get("Role");
                        CLIUtils.printDetail(printWriter, fields, this.data);
                    }
                    break block9;
                }
                throw new StatementException(Localization.getString(BUNDLE, "mod_user_no_user", stringArray[0]));
            }
            catch (NSMUIException nSMUIException) {
                throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "mod_user_add_error"), 99);
            }
        }
    }
}

