/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.nsmui.admin.AttributeCommand;
import com.sun.netstorage.mgmt.nsmui.admin.LoggingCommand;
import com.sun.netstorage.mgmt.nsmui.alarms.AlarmsCommand;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.discovery.DiscoveryCommand;
import com.sun.netstorage.mgmt.nsmui.notification.EmailCommand;
import com.sun.netstorage.mgmt.nsmui.notification.SNMPCommand;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;

public class ShowPropertiesCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.ShowPropertiesCLI";
    private static final String ADMIN_BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private static final CommandOption[] OPTIONS = new CommandOption[0];
    private static final String[] fields = new String[]{Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.ShowPropertiesCLI", "alarm_expiration_label"), Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.ShowPropertiesCLI", "discovery_polling_label"), Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.ShowPropertiesCLI", "contact_email_label"), Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.ShowPropertiesCLI", "logging_label"), Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.ShowPropertiesCLI", "smtp_server_label"), Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.ShowPropertiesCLI", "t3_application_label"), Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.ShowPropertiesCLI", "t4_application_label"), Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.ShowPropertiesCLI", "email_notification_label"), Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.ShowPropertiesCLI", "snmp_notification_label")};
    private String[] data = new String[fields.length];

    public ShowPropertiesCLICommand() {
        super(BUNDLE, "ShowProperties", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Object object;
        Object object2;
        Utils.cliSecurityCheck("Admin");
        int n = 0;
        try {
            object2 = new AlarmsCommand();
            long l = ((AlarmsCommand)object2).getExpirationTime() / 1000L / 60L;
            String[] stringArray = Utils.getTimeValue(String.valueOf(l));
            this.data[n++] = stringArray[0] + " " + Localization.getString(ADMIN_BUNDLE, stringArray[1]);
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "alarm_retrieval_error"), 99);
        }
        try {
            object2 = new DiscoveryCommand();
            this.data[n++] = String.valueOf(((DiscoveryCommand)object2).getRefreshInterval() / 1000L / 60L) + " " + Localization.getString(BUNDLE, "discovery_polling_units");
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "polling_retrieval_error"), 99);
        }
        catch (Exception exception) {
            throw new CommandException(exception, Localization.getString(BUNDLE, "polling_retrieval_error"), 99);
        }
        try {
            object2 = new AttributeCommand();
            ((AttributeCommand)object2).run();
            this.data[n++] = ((AttributeCommand)object2).getAttribute("contactemail");
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException.getCause(), Localization.getString(BUNDLE, "contact_retrieval_error"), 99);
        }
        try {
            object = new LoggingCommand();
            ((LoggingCommand)object).run();
            this.data[n++] = Localization.getString(ADMIN_BUNDLE, Utils.mapSeverityToToken(Integer.toString(((LoggingCommand)object).getLoggingThreshold())));
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException.getCause(), Localization.getString(BUNDLE, "logging_retrieval_error"), 99);
        }
        try {
            object = new EmailCommand();
            ((EmailCommand)object).run();
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "email_retrieval_error"), 99);
        }
        try {
            this.data[n++] = ((EmailCommand)object).getSMTPHost();
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "smtp_retrieval_error"), 99);
        }
        try {
            this.data[n++] = Localization.getString(ADMIN_BUNDLE, ((AttributeCommand)object2).getAttribute("t3management"));
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException.getCause(), Localization.getString(BUNDLE, "att_retrieval_error"), 99);
        }
        try {
            this.data[n++] = Localization.getString(ADMIN_BUNDLE, ((AttributeCommand)object2).getAttribute("t4management"));
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException.getCause(), Localization.getString(BUNDLE, "att_retrieval_error"), 99);
        }
        try {
            this.data[n++] = ((EmailCommand)object).isPaused() ? Localization.getString(BUNDLE, "off") : Localization.getString(BUNDLE, "on");
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "email_retrieval_error"), 99);
        }
        try {
            SNMPCommand sNMPCommand = new SNMPCommand();
            sNMPCommand.run();
            this.data[n++] = sNMPCommand.isPaused() ? Localization.getString(BUNDLE, "off") : Localization.getString(BUNDLE, "on");
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "snmp_retrieval_error"), 99);
        }
        CLIUtils.printDetail(printWriter, fields, this.data);
    }
}

