/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.common.clip.StatementOption;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.notification.SNMPCommand;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;
import java.util.Arrays;

public class SnmpNotificationsCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.SnmpNotificationsCLI";
    private static final String NOTIFICATION_BUNDLE = "com.sun.netstorage.mgmt.nsmui.notification.Localization";
    private static final int DEFAULT_SORT_COL = -2;
    private static final TableColumn[] COLUMNS = new TableColumn[5];
    private static final int ID_COLUMN = 0;
    private static final int LEVEL_COLUMN = 1;
    private static final int HOST_COLUMN = 2;
    private static final int PORT_COLUMN = 3;
    private static final int LOCALE_COLUMN = 4;
    private SNMPCommand snmpCommand;
    private static final CommandOption[] OPTIONS = new CommandOption[]{CommandOption.newOption('s', "sort", false), CommandOption.newOption('r', "reverse", false)};

    public SnmpNotificationsCLICommand() {
        super(BUNDLE, "SnmpNotifications", OPTIONS);
        if (COLUMNS[0] == null) {
            SnmpNotificationsCLICommand.COLUMNS[0] = new TableColumn(Localization.getString(NOTIFICATION_BUNDLE, "snmp_table_title_id"), true, "\"left\"");
            SnmpNotificationsCLICommand.COLUMNS[1] = new TableColumn(Localization.getString(NOTIFICATION_BUNDLE, "snmp_table_title_level"), true, "\"left\"");
            SnmpNotificationsCLICommand.COLUMNS[2] = new TableColumn(Localization.getString(NOTIFICATION_BUNDLE, "snmp_table_title_hostname"), true, "\"left\"");
            SnmpNotificationsCLICommand.COLUMNS[3] = new TableColumn(Localization.getString(NOTIFICATION_BUNDLE, "snmp_table_title_port"), true, "\"right\"");
            SnmpNotificationsCLICommand.COLUMNS[4] = new TableColumn(Localization.getString(NOTIFICATION_BUNDLE, "snmp_table_title_locale"), true, "\"left\"");
        }
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Admin");
        try {
            String[][] stringArray;
            this.snmpCommand = new SNMPCommand();
            this.snmpCommand.run();
            int n = -2;
            StatementOption statementOption = statement.getOption('s');
            if (statementOption != null) {
                n = new Integer(statementOption.getArgument());
            }
            if ((statementOption = statement.getOption('r')) != null) {
                n = new Integer("-" + statementOption.getArgument());
            }
            if ((stringArray = this.snmpCommand.getContracts()).length > 0) {
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    stringArray[n3][4] = Localization.getString(NOTIFICATION_BUNDLE, stringArray[n3][4]);
                    ++n3;
                }
                Arrays.sort(stringArray, new SmartColumnComparator(n));
                int n4 = 0;
                while (n4 < n2) {
                    stringArray[n4][1] = Localization.getString(NOTIFICATION_BUNDLE, Utils.mapSeverityToToken(stringArray[n4][1]));
                    ++n4;
                }
                if (stringArray == null) {
                    printWriter.println(Localization.getString(NOTIFICATION_BUNDLE, "no_snmp_contracts"));
                } else {
                    CLIUtils.printTable(printWriter, COLUMNS, stringArray);
                }
            } else {
                printWriter.println(Localization.getString(NOTIFICATION_BUNDLE, "no_snmp_contracts"));
            }
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "snmp_retrieval_error"), 99);
        }
    }
}

