/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.nsmui.admin.AdminCommand;
import com.sun.netstorage.mgmt.nsmui.admin.AttributeCommand;
import com.sun.netstorage.mgmt.nsmui.alarms.AlarmsCommand;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.launch.LaunchImpl;
import com.sun.netstorage.mgmt.nsmui.launch.LaunchSanBoxManager;
import com.sun.netstorage.mgmt.nsmui.launch.LaunchSanSurfer;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class StatusCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.StatusCLI";
    private static final String STATUS_BUNDLE = "com.sun.netstorage.mgmt.nsmui.status.Localization";
    private static final String ADMIN_BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private static final TableColumn[] COLUMNS = new TableColumn[]{new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.status.Localization", "quantity"), false, "\"right\""), new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.status.Localization", "severity"), false, "\"left\"")};
    public static final int COLUMN_NUMBER = COLUMNS.length;
    private static final int COUNT_COLUMN = 0;
    private static final int LEVEL_COLUMN = 1;
    private static final TableColumn[] APP_COLUMNS = new TableColumn[]{new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.status.Localization", "application"), false, "\"left\""), new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.status.Localization", "status"), false, "\"left\"")};
    public static final int APP_COLUMN_NUMBER = APP_COLUMNS.length;
    private static final int APP_COLUMN = 0;
    private static final int STATUS_COLUMN = 1;
    private AlarmsCommand alarmsCommand = null;
    private AdminCommand adminCommand;
    private AttributeCommand attributeCommand;
    private static final CommandOption[] OPTIONS = new CommandOption[0];

    public StatusCLICommand() {
        super(BUNDLE, "Status", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Guest");
        try {
            this.alarmsCommand = new AlarmsCommand();
            this.alarmsCommand.run();
            this.adminCommand = new AdminCommand();
            this.adminCommand.run();
            this.attributeCommand = new AttributeCommand();
            this.attributeCommand.run();
            String[][] stringArray = this.getAlarmsTable();
            if (stringArray == null) {
                printWriter.println(Localization.getString(STATUS_BUNDLE, "no_alarms"));
            } else {
                CLIUtils.printTable(printWriter, COLUMNS, stringArray);
            }
            printWriter.println("");
            String[][] stringArray2 = this.getInstalledApplicationsTable();
            if (stringArray2 == null) {
                printWriter.println(Localization.getString(STATUS_BUNDLE, "no_appllications"));
            } else {
                CLIUtils.printTable(printWriter, APP_COLUMNS, stringArray2);
            }
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "status_retrieval_error"), 99);
        }
    }

    public String[][] getAlarmsTable() {
        String[][] stringArray = new String[4][COLUMN_NUMBER];
        if (this.alarmsCommand.count() != 0) {
            stringArray[0][0] = String.valueOf(this.alarmsCommand.getNumberOfAlarms("down"));
            stringArray[0][1] = Localization.getString(STATUS_BUNDLE, "severity_level_down");
            stringArray[1][0] = String.valueOf(this.alarmsCommand.getNumberOfAlarms("critical"));
            stringArray[1][1] = Localization.getString(STATUS_BUNDLE, "severity_level_critical");
            stringArray[2][0] = String.valueOf(this.alarmsCommand.getNumberOfAlarms("major"));
            stringArray[2][1] = Localization.getString(STATUS_BUNDLE, "severity_level_major");
            stringArray[3][0] = String.valueOf(this.alarmsCommand.getNumberOfAlarms("minor"));
            stringArray[3][1] = Localization.getString(STATUS_BUNDLE, "severity_level_minor");
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public String[][] getInstalledApplicationsTable() throws NSMUIException {
        String[][] stringArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(Localization.getString(ADMIN_BUNDLE, "available_applications"), " ");
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n = 0;
        String string = "";
        String string2 = "";
        while (stringTokenizer.hasMoreElements()) {
            LaunchImpl launchImpl;
            String string3 = (String)stringTokenizer.nextElement();
            String[] stringArray2 = new String[2];
            if (string3.equals("sscs")) {
                stringArray2 = this.checkURLApp(string3);
            } else if (string3.equals("hicommand")) {
                stringArray2 = this.checkURLApp(string3);
            } else if (string3.equals("sansurfer")) {
                if (Utils.isRunningOnSolaris()) {
                    launchImpl = new LaunchSanSurfer();
                    if (launchImpl.isPackageInstalled()) {
                        stringArray2[0] = HTMLTags.getCustomTag(ADMIN_BUNDLE, string3);
                        stringArray2[1] = HTMLTags.getCustomTag(STATUS_BUNDLE, "available");
                    } else {
                        stringArray2 = null;
                    }
                } else {
                    stringArray2 = null;
                }
            } else if (string3.equals("sanboxmanager")) {
                if (Utils.isRunningOnSolaris()) {
                    launchImpl = new LaunchSanBoxManager();
                    if (launchImpl.isPackageInstalled()) {
                        stringArray2[0] = HTMLTags.getCustomTag(ADMIN_BUNDLE, string3);
                        stringArray2[1] = HTMLTags.getCustomTag(STATUS_BUNDLE, "available");
                    } else {
                        stringArray2 = null;
                    }
                } else {
                    stringArray2 = null;
                }
            } else if (string3.equals("sade")) {
                stringArray2 = this.checkURLApp(string3);
            } else if (string3.equals("webtools")) {
                stringArray2[0] = HTMLTags.getCustomTag(ADMIN_BUNDLE, string3);
                stringArray2[1] = Localization.getString(ADMIN_BUNDLE, "brocade_application", string3);
            }
            if (stringArray2 == null) continue;
            arrayList.add(stringArray2);
        }
        int n2 = arrayList.size();
        stringArray = new String[arrayList.size()][2];
        n = 0;
        while (n < arrayList.size()) {
            stringArray[n] = (String[])arrayList.get(n);
            ++n;
        }
        return stringArray;
    }

    private String[] checkURLApp(String string) throws NSMUIException {
        String[] stringArray = new String[2];
        stringArray[0] = HTMLTags.getCustomTag(ADMIN_BUNDLE, string);
        String string2 = this.attributeCommand.getAttribute(string);
        if (string2 != null && !string2.equals("")) {
            stringArray[1] = AdminCommand.checkURLConnection(string2) ? HTMLTags.getCustomTag(STATUS_BUNDLE, "available") : Localization.getString(ADMIN_BUNDLE, "connection_problem", string2);
        } else {
            stringArray = null;
        }
        return stringArray;
    }
}

