/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyDetailCommand;
import com.sun.netstorage.mgmt.nsmui.topology.ZoneUtil;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TopologyElementNotFoundException;
import com.sun.netstorage.mgmt.services.topology.TopologyServiceImpl;
import com.sun.netstorage.mgmt.services.topology.Zone;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class TopologyCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.TopologyCLI";
    private static final String TOPOLOGY_BUNDLE = "com.sun.netstorage.mgmt.nsmui.topology.Localization";
    private static final CommandOption[] OPTIONS = new CommandOption[0];

    public TopologyCLICommand() {
        super(BUNDLE, "Topology", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        String[] stringArray = statement.getOperands();
        if (stringArray.length < 1 || stringArray.length > 2) {
            throw new StatementException(Localization.getString(BUNDLE, "incorrectOperandCount"));
        }
        this.printSANTopology(printWriter, stringArray[0], stringArray.length == 2 ? stringArray[1] : null);
    }

    public static SanTopology getSanTopology() throws TopologyElementNotFoundException {
        boolean bl;
        String string = System.getProperty("stubDB");
        if (string != null) {
            return TopologyServiceImpl.getInstance().getSanTopologySim(string);
        }
        boolean bl2 = bl = System.getProperty("debugDB") != null;
        if (bl) {
            return TopologyServiceImpl.getInstance().getSanTopology("", new PrintWriter(System.out, true));
        }
        return TopologyServiceImpl.getInstance().getSanTopology("");
    }

    public void printSANTopology(PrintWriter printWriter, String string, String string2) throws CommandException {
        FabricTopology[] fabricTopologyArray = null;
        try {
            fabricTopologyArray = TopologyCLICommand.getSanTopology().getFabrics();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new CommandException(throwable, Localization.getString(BUNDLE, "exception"), 99);
        }
        if (fabricTopologyArray == null || fabricTopologyArray.length == 0) {
            printWriter.println(Localization.getString(BUNDLE, "noFabricsFound"));
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < fabricTopologyArray.length) {
            block18: {
                Object object;
                int n2;
                Zone[] zoneArray;
                Zone[] zoneArray2;
                ArrayList<Zone> arrayList;
                String string3;
                String string4;
                block19: {
                    string4 = fabricTopologyArray[n].getFabricId().getFabricName();
                    string3 = fabricTopologyArray[n].getFabricId().getLogicalName();
                    if (string != null && !string.equals(string4) && !string.equals(string3)) break block18;
                    bl = true;
                    arrayList = new ArrayList<Zone>();
                    if (string2 == null) break block19;
                    zoneArray2 = string2 + " (";
                    zoneArray = fabricTopologyArray[n].getZones();
                    n2 = 0;
                    while (n2 < zoneArray.length) {
                        object = zoneArray[n2].getName();
                        if (((String)object).equals(string2) || ((String)object).startsWith((String)zoneArray2) && ((String)object).endsWith(")")) {
                            arrayList.add(zoneArray[n2]);
                        }
                        ++n2;
                    }
                    if (arrayList.size() == 0) break block18;
                    bl2 = true;
                }
                if (string2 == null) {
                    zoneArray2 = new StringBuffer();
                    zoneArray = fabricTopologyArray[n].getZones();
                    n2 = 0;
                    while (n2 < zoneArray.length) {
                        if (n2 > 0) {
                            zoneArray2.append(", ");
                        }
                        zoneArray2.append(ZoneUtil.localizeZoneName(zoneArray[n2].getName()));
                        ++n2;
                    }
                    CLIUtils.printDetail(printWriter, new String[]{Localization.getString(BUNDLE, "fabric"), Localization.getString(BUNDLE, "zones")}, new String[]{string3 != null ? string3 : string4, zoneArray2.toString()}, "\"left\"");
                }
                try {
                    zoneArray2 = arrayList.toArray(new Zone[arrayList.size()]);
                    int n3 = 0;
                    while (n3 == 0 || n3 < zoneArray2.length) {
                        Zone zone = n3 < zoneArray2.length ? zoneArray2[n3] : null;
                        object = new TopologyDetailCommand(fabricTopologyArray[n].getPhysicalTopology(), null, zone, false);
                        ((TopologyDetailCommand)object).run();
                        if (zone != null) {
                            CLIUtils.printDetail(printWriter, new String[]{Localization.getString(BUNDLE, "fabric"), Localization.getString(BUNDLE, "zone")}, new String[]{string4, ZoneUtil.localizeZoneName(zone.getName())}, "\"right\"");
                            printWriter.println(Localization.getString(TOPOLOGY_BUNDLE, "zoningNote"));
                        }
                        String[][] stringArray = ((TopologyDetailCommand)object).getTableData(null);
                        Arrays.sort(stringArray, new SmartColumnComparator(1));
                        CLIUtils.printTable(printWriter, TopologyDetailCommand.getColumns(), stringArray);
                        ++n3;
                    }
                }
                catch (DataRetrievalException dataRetrievalException) {
                    throw new CommandException(dataRetrievalException.getCause() != null ? dataRetrievalException.getCause() : dataRetrievalException, dataRetrievalException.getMessage(), 99);
                }
                printWriter.println();
                printWriter.flush();
            }
            ++n;
        }
        if (string != null && !bl) {
            printWriter.println(Localization.getString(BUNDLE, "fabricNotFound", string));
        } else if (string2 != null && !bl2) {
            printWriter.println(Localization.getString(BUNDLE, "zoneNotFound", string2));
        }
    }
}

