/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.common;

import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class MotherServlet
extends HttpServlet {
    protected String[] ROLES_ALLOWED = null;
    protected String PAGE_URL;
    protected boolean debug;
    protected String role = null;
    protected String page_name = null;
    protected String find = null;
    protected int sortBy = 0;
    protected String SORT_BY = null;
    protected boolean SORT_ORDER = false;
    protected String id_paramValue;
    protected boolean accessAllowed = false;

    protected abstract void checkActions(HttpServletRequest var1, HttpServletResponse var2) throws Exception, ServletException, IOException;

    protected void _checkActions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception, ServletException, IOException {
        if (this.debug) {
            UtilsWeb.printParams(httpServletRequest);
        }
        this.checkActions(httpServletRequest, httpServletResponse);
    }

    protected void _initMe(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.PAGE_URL = httpServletRequest.getRequestURI();
        if (httpServletRequest.getQueryString() != null) {
            this.PAGE_URL = this.PAGE_URL + "?" + httpServletRequest.getQueryString();
        }
        this._checkSecurity(httpServletRequest, httpServletResponse);
        HTMLTags.addTimestamp(httpServletRequest, "start");
        this._getParams(httpServletRequest, httpServletResponse);
    }

    protected void _checkSecurity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.role = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, null);
        if (this.ROLES_ALLOWED != null && this.ROLES_ALLOWED.length != 0) {
            int n = 0;
            while (n < this.ROLES_ALLOWED.length) {
                if (this.ROLES_ALLOWED[n] == null || this.ROLES_ALLOWED[n].equalsIgnoreCase(this.role)) {
                    this.accessAllowed = true;
                    break;
                }
                ++n;
            }
        } else {
            this.accessAllowed = true;
        }
        if (this.accessAllowed) {
            return;
        }
        UtilsWeb.noCacheHeader(httpServletResponse);
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string = "Access Denied";
        printWriter.print(HTMLTags.getErrorBoxTag(string));
        printWriter.flush();
        throw new SecurityException(string);
    }

    protected abstract void displayTop(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected void _displayTop(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        UtilsWeb.noCacheHeader(httpServletResponse);
        PrintWriter printWriter = httpServletResponse.getWriter();
        this.displayTop(httpServletRequest, httpServletResponse);
        printWriter.flush();
        HTMLTags.addTimestamp(httpServletRequest, "masthead");
        printWriter.println(HTMLTags.getContentStartTags(this.PAGE_URL));
        printWriter.print(HTMLTags.getPendingMessagesTag(httpServletRequest));
    }

    protected abstract void getParams(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected void _getParams(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.find = httpServletRequest.getParameter("find");
        this.sortBy = HTMLTags.getTableSortColumn(httpServletRequest, this.getDefaultSortColumn());
        this.SORT_ORDER = this.sortBy > 0;
        this.sortBy = this.sortBy > 0 ? this.sortBy - 1 : this.sortBy + 1;
        this.SORT_BY = null;
        this.debug = httpServletRequest.getParameter("debug") != null;
        this.id_paramValue = httpServletRequest.getParameter("id");
        this.getParams(httpServletRequest, httpServletResponse);
        HTMLTags.addTimestamp(httpServletRequest, "get_params");
    }

    public abstract int getDefaultSortColumn();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doItCatchAll(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        PrintWriter printWriter = httpServletResponse.getWriter();
        boolean bl = false;
        try {
            try {
                this._clearState(httpServletRequest, httpServletResponse);
                this._initMe(httpServletRequest, httpServletResponse);
                this._checkActions(httpServletRequest, httpServletResponse);
                this._displayTop(httpServletRequest, httpServletResponse);
                bl = true;
                this.doIt(httpServletRequest, httpServletResponse);
                HTMLTags.addTimestamp(httpServletRequest, "display_data");
            }
            catch (LoginException loginException) {
                Object var9_6 = null;
                HTMLTags.removePendingMessages(httpServletRequest, "warningMessages");
                HTMLTags.removePendingMessages(httpServletRequest, "infoMessages");
                HTMLTags.removePendingMessages(httpServletRequest, "errorMessages");
                printWriter.println(HTMLTags.getContentEndTags());
                printWriter.println(HTMLTags.getTimestampTags(httpServletRequest));
                printWriter.flush();
                printWriter.close();
                return;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    try {
                        this._displayTop(httpServletRequest, httpServletResponse);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                printWriter.print(HTMLTags.getExceptionBoxTag(httpServletRequest, this.page_name, throwable));
                Object var9_7 = null;
                HTMLTags.removePendingMessages(httpServletRequest, "warningMessages");
                HTMLTags.removePendingMessages(httpServletRequest, "infoMessages");
                HTMLTags.removePendingMessages(httpServletRequest, "errorMessages");
                printWriter.println(HTMLTags.getContentEndTags());
                printWriter.println(HTMLTags.getTimestampTags(httpServletRequest));
                printWriter.flush();
                printWriter.close();
                return;
            }
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            HTMLTags.removePendingMessages(httpServletRequest, "warningMessages");
            HTMLTags.removePendingMessages(httpServletRequest, "infoMessages");
            HTMLTags.removePendingMessages(httpServletRequest, "errorMessages");
            printWriter.println(HTMLTags.getContentEndTags());
            printWriter.println(HTMLTags.getTimestampTags(httpServletRequest));
            printWriter.flush();
            printWriter.close();
            throw throwable;
        }
        HTMLTags.removePendingMessages(httpServletRequest, "warningMessages");
        HTMLTags.removePendingMessages(httpServletRequest, "infoMessages");
        HTMLTags.removePendingMessages(httpServletRequest, "errorMessages");
        printWriter.println(HTMLTags.getContentEndTags());
        printWriter.println(HTMLTags.getTimestampTags(httpServletRequest));
        printWriter.flush();
        printWriter.close();
    }

    protected void _clearState(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.debug = false;
        this.role = null;
        this.page_name = null;
        this.find = null;
        this.sortBy = 0;
        this.SORT_BY = null;
        this.SORT_ORDER = false;
        this.id_paramValue = null;
        this.accessAllowed = false;
        this.clearState(httpServletRequest, httpServletResponse);
    }

    protected abstract void clearState(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract void doIt(HttpServletRequest var1, HttpServletResponse var2) throws Throwable;

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doItCatchAll(httpServletRequest, httpServletResponse);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doItCatchAll(httpServletRequest, httpServletResponse);
    }

    public void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doItCatchAll(httpServletRequest, httpServletResponse);
    }

    public void init() throws ServletException {
    }

    public void destroy() {
    }
}

