/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.common.test;

import com.sun.netstorage.mgmt.nsmui.common.ExpirableRun;

public class ExpirableRunTest {
    public static void test1() {
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    long l = 0L;
                    while (l >= 0L) {
                        ++l;
                    }
                    System.out.println("Normal exit from program l=" + l);
                }
            };
            new ExpirableRun(runnable, 2000L).run();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
        }
    }

    public static void test2() {
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    long l = 0L;
                    try {
                        while (l >= 0L) {
                            ++l;
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("Execution interrupted: ");
                        exception.printStackTrace();
                        return;
                    }
                    System.out.println("Normal exit from program l=" + l);
                }
            };
            new ExpirableRun(runnable, 2000L).run();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
        }
    }

    public static void test3() {
        long l = 0L;
        Runtime.getRuntime().gc();
        long l2 = Runtime.getRuntime().freeMemory();
        while (true) {
            ExpirableRunTest.test1();
            Runtime.getRuntime().gc();
            long l3 = Runtime.getRuntime().freeMemory();
            System.out.println(++l + "] memory delta=" + (l3 - l2));
            l2 = l3;
        }
    }

    public static void main(String[] stringArray) {
        ExpirableRunTest.test1();
        ExpirableRunTest.test2();
        ExpirableRunTest.test3();
    }
}

