/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.hba;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.datamodel.Asset;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.component.model.api.gui.HBAAsset;
import com.sun.netstorage.mgmt.nsmui.common.DataInterpretationException;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.hba.HbaConstants;
import com.sun.netstorage.mgmt.nsmui.util.Utils;

public class HbaDetailCommand {
    private HBAAsset device;
    public static int ROWS = HbaConstants.DETAIL_ROW_NUMBER;
    private final String deviceId;
    private final boolean remove;

    public HbaDetailCommand(String string, boolean bl) throws NSMUIException {
        if (string == null || string.equals("")) {
            throw new NSMUIException("deviceid==null", null);
        }
        this.deviceId = string;
        this.remove = bl;
    }

    public void run() throws DataRetrievalException, DataInterpretationException {
        this.device = null;
        try {
            Asset asset = Utils.getAssetStorage().getAsset(this.deviceId);
            if (asset != null) {
                this.device = (HBAAsset)Utils.getAssetStorage().getAsset(this.deviceId);
                if (this.remove) {
                    this.device.delete();
                    this.device = null;
                }
            }
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
        catch (Exception exception) {
            throw new DataInterpretationException("Error with asset's model object", exception);
        }
    }

    public boolean isStale() {
        return this.device == null ? false : this.device.isStale();
    }

    public String[] getValues() throws PersistenceException {
        String[] stringArray = new String[ROWS];
        if (this.device == null) {
            return null;
        }
        stringArray[0] = this.device.getHost() == null ? "null" : this.device.getHost().getName();
        stringArray[1] = this.device.getPath();
        stringArray[2] = Utils.getVendorModel(this.device.getVendor(), this.device.getModel());
        stringArray[3] = this.device.getFirmwareRev();
        return stringArray;
    }

    public String getHostKey() {
        try {
            return this.device.getHost().getKey();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDeviceKey() {
        return this.device == null ? null : this.device.getKey();
    }

    public String getDeviceName() {
        String string = "com.sun.netstorage.mgmt.nsmui.host.Localization";
        return this.device == null || this.device.getName() == null ? Localization.getString(string, "unknown_controller") : this.device.getName();
    }

    static void main(String[] stringArray) throws Exception {
        HbaDetailCommand hbaDetailCommand = new HbaDetailCommand("sydney.central", false);
        hbaDetailCommand.run();
        String[] stringArray2 = hbaDetailCommand.getValues();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("->" + stringArray2[n]);
            ++n;
        }
    }
}

