/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.hba;

import com.sun.netstorage.mgmt.common.datamodel.Asset;
import com.sun.netstorage.mgmt.common.datamodel.AssetStorage;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.component.model.api.gui.HBAAsset;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.hba.HbaConstants;
import com.sun.netstorage.mgmt.nsmui.util.Utils;

public class HbaInventoryCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.hba.Localization";
    AssetStorage pm;
    private Asset[] assets;
    private String[] sortBy;
    private boolean[] sortOrder;
    private String find = null;

    public HbaInventoryCommand(String string, boolean bl, String string2) {
        if (string == null) {
            this.sortBy = new String[0];
            this.sortOrder = new boolean[0];
        } else {
            this.sortBy = new String[]{string};
            this.sortOrder = new boolean[]{bl};
        }
        this.find = string2;
    }

    public void run() throws DataRetrievalException {
        this.assets = null;
        try {
            this.assets = Utils.getAssetStorage().getAssets("HBA", this.find, this.sortBy, this.sortOrder);
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
    }

    public String[][] getValues() throws PersistenceException {
        if (this.assets == null || this.assets.length == 0) {
            return null;
        }
        String[][] stringArray = new String[this.assets.length][HbaConstants.COLUMN_NUMBER];
        int n = 0;
        while (n < this.assets.length) {
            Asset asset = this.assets[n];
            if (asset == null) {
                this._fillError("Null Asset", stringArray[n]);
            } else if (!(asset instanceof HBAAsset)) {
                this._fillError("Asset is not of type HBAAsset", stringArray[n]);
            } else {
                HBAAsset hBAAsset = (HBAAsset)asset;
                stringArray[n][0] = hBAAsset.getKey();
                stringArray[n][1] = hBAAsset.getPath();
                stringArray[n][2] = hBAAsset.getHost() == null ? "" : Utils.createDuplet(hBAAsset.getHost().getKey(), hBAAsset.getHost().getName());
                stringArray[n][3] = Utils.getVendorModel(hBAAsset.getVendor(), hBAAsset.getModel());
                stringArray[n][4] = hBAAsset.getFirmwareRev();
            }
            ++n;
        }
        return stringArray;
    }

    private void _fillError(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length > 1) {
            stringArray[1] = string;
        }
    }

    static void main(String[] stringArray) throws Exception {
        HbaInventoryCommand hbaInventoryCommand = new HbaInventoryCommand(null, false, null);
        hbaInventoryCommand.run();
        String[][] stringArray2 = hbaInventoryCommand.getValues();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("->" + stringArray2[n][0]);
            ++n;
        }
    }
}

