/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.hba;

import com.sun.netstorage.mgmt.common.datamodel.AssetStorage;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.component.model.api.gui.HBAAsset;
import com.sun.netstorage.mgmt.component.model.api.gui.HBAPort;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.hba.HbaConstants;
import com.sun.netstorage.mgmt.nsmui.util.Utils;

public class HbaPortsCommand {
    private static final boolean debug = false;
    AssetStorage pm;
    HBAAsset asset;
    private HBAPort[] ports;
    private String key;
    private String[] sortBy;
    private boolean[] sortOrder;
    private String find = null;

    public HbaPortsCommand(String string, boolean bl, String string2) {
        if (string == null) {
            this.sortBy = new String[0];
            this.sortOrder = new boolean[0];
        } else {
            this.sortBy = new String[]{string};
            this.sortOrder = new boolean[]{bl};
        }
        this.find = string2;
    }

    public void run() throws DataRetrievalException {
        this.ports = null;
        try {
            this.asset = (HBAAsset)Utils.getAssetStorage().getAsset(this.find);
            if (this.asset == null) {
                return;
            }
            this.ports = this.asset.getPorts(this.sortBy, this.sortOrder);
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
    }

    public String[][] getValues() throws PersistenceException {
        if (this.ports == null || this.ports.length == 0) {
            return null;
        }
        String[][] stringArray = new String[this.ports.length][HbaConstants.PORTS_COLUMN_NUMBER];
        int n = 0;
        while (n < this.ports.length) {
            HBAPort hBAPort = this.ports[n];
            int n2 = 0;
            stringArray[n][n2++] = hBAPort.getKey();
            stringArray[n][n2++] = hBAPort.getState();
            stringArray[n][n2++] = hBAPort.getAddressIdentifier();
            stringArray[n][n2++] = hBAPort.getWWN();
            stringArray[n][n2++] = hBAPort.getPortType();
            stringArray[n][n2++] = Utils.createDuplet(hBAPort.getHost() == null ? null : hBAPort.getHost().getKey(), hBAPort.getHost() == null ? null : hBAPort.getHost().getName());
            stringArray[n][n2++] = hBAPort.getNodeWWN();
            ++n;
        }
        return stringArray;
    }

    public String getDeviceKey() {
        return this.asset == null ? null : this.asset.getKey();
    }

    public String getDeviceName() {
        return this.asset == null ? null : this.asset.getName();
    }

    private void _fillError(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length > 1) {
            stringArray[1] = string;
        }
    }

    static void main(String[] stringArray) throws Exception {
        HbaPortsCommand hbaPortsCommand = new HbaPortsCommand(null, false, null);
        hbaPortsCommand.run();
        String[][] stringArray2 = hbaPortsCommand.getValues();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("->" + stringArray2[n][0]);
            ++n;
        }
    }
}

