/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.host;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.component.model.api.gui.HBAAsset;
import com.sun.netstorage.mgmt.component.model.api.gui.HostAsset;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.hba.HbaConstants;
import com.sun.netstorage.mgmt.nsmui.hba.HbaPortsCommand;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.StubData;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;

public class HostConnectivityCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.host.Localization";
    private static final TableColumn[] COLUMNS = new TableColumn[HbaConstants.PORTS_COLUMNS.length - 1];
    public static final int HBA_COLUMN = 0;
    public static final int HOST_COLUMN = 5;
    static final int DEFAULT_SORT_COL = 1;
    private final boolean htmlOk;
    private final String hostId;
    private StubData stubData;
    private HostAsset host;
    private String[][] portData;

    public static TableColumn[] getColumns() {
        if (COLUMNS[0] == null) {
            System.arraycopy(HbaConstants.PORTS_COLUMNS, 0, COLUMNS, 0, 5);
            System.arraycopy(HbaConstants.PORTS_COLUMNS, 6, COLUMNS, 5, HbaConstants.PORTS_COLUMNS.length - 6);
            HostConnectivityCommand.COLUMNS[0] = new TableColumn(Localization.getString(BUNDLE, "hba"), true, "\"left\"");
        }
        return COLUMNS;
    }

    public HostConnectivityCommand(String string, boolean bl) {
        this.hostId = string;
        this.htmlOk = bl;
    }

    public String getHostName() {
        if (this.stubData != null) {
            return "Fake Host";
        }
        return this.host != null ? this.host.getName() : "";
    }

    void stubData() {
        TableColumn[] tableColumnArray = HostConnectivityCommand.getColumns();
        String[] stringArray = new String[tableColumnArray.length];
        int n = 0;
        while (n < tableColumnArray.length) {
            stringArray[n] = tableColumnArray[n].title;
            ++n;
        }
        this.stubData = new StubData(stringArray, 102);
    }

    public boolean run() throws DataRetrievalException {
        if (this.stubData != null) {
            return true;
        }
        try {
            this.host = (HostAsset)Utils.getGuiPersistenceManager().getAsset(this.hostId);
            if (this.host == null) {
                return false;
            }
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            HBAAsset[] hBAAssetArray = this.host.getHBAs(null, null);
            int n = 0;
            while (n < hBAAssetArray.length) {
                String string = this.getHBAData(hBAAssetArray[n]);
                HbaPortsCommand hbaPortsCommand = new HbaPortsCommand(null, false, hBAAssetArray[n].getKey());
                hbaPortsCommand.run();
                String[][] stringArray = hbaPortsCommand.getValues();
                if (stringArray != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        String[] stringArray2 = new String[COLUMNS.length];
                        System.arraycopy(stringArray[n2], 0, stringArray2, 0, 5);
                        System.arraycopy(stringArray[n2], 6, stringArray2, 5, stringArray[n2].length - 6);
                        stringArray2[0] = string;
                        arrayList.add(stringArray2);
                        ++n2;
                    }
                }
                ++n;
            }
            this.portData = (String[][])arrayList.toArray((T[])new String[arrayList.size()][0]);
            return true;
        }
        catch (Exception exception) {
            throw new DataRetrievalException(exception);
        }
    }

    private String getHBAData(HBAAsset hBAAsset) throws PersistenceException {
        if (hBAAsset == null) {
            return "";
        }
        String string = NSMPages.getPageURL(NSMPages.HBA_DETAILS_PAGE);
        String string2 = hBAAsset.getName();
        if (string2 == null) {
            string2 = Localization.getString(BUNDLE, "unknown_controller");
        }
        if (this.htmlOk && string != null) {
            return HTMLTags.getLinkTag(HTMLTags.modifyURLParameter(string, "id", hBAAsset.getKey()), string2);
        }
        return string2;
    }

    public int getRowCount() {
        if (this.stubData != null) {
            return this.stubData.getCount();
        }
        return this.portData != null ? this.portData.length : 0;
    }

    public String[][] getTableData(HTMLTags.TableInfo tableInfo) {
        String[][] stringArray = this.stubData != null ? this.stubData.getData() : this.portData;
        int n = Math.abs(tableInfo.sortColumn) - 1;
        if (n >= 0 && n < COLUMNS.length) {
            Arrays.sort(stringArray, new SmartColumnComparator(tableInfo.sortColumn));
        }
        int n2 = Math.min(tableInfo.pageSize, stringArray.length - tableInfo.firstRow);
        String[][] stringArray2 = new String[n2][];
        System.arraycopy(stringArray, tableInfo.firstRow, stringArray2, 0, n2);
        return stringArray2;
    }
}

