/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.host;

import com.sun.netstorage.mgmt.common.datamodel.Asset;
import com.sun.netstorage.mgmt.common.datamodel.AssetStorage;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.component.model.api.gui.HostAsset;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.host.HostConstants;
import com.sun.netstorage.mgmt.nsmui.util.Utils;

public class HostInventoryCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.host.Localization";
    AssetStorage pm;
    private Asset[] assets;
    private String[] sortBy;
    private boolean[] sortOrder;
    private String find = null;

    public HostInventoryCommand(String string, boolean bl, String string2) {
        if (string == null) {
            this.sortBy = new String[0];
            this.sortOrder = new boolean[0];
        } else {
            this.sortBy = new String[]{string};
            this.sortOrder = new boolean[]{bl};
        }
        this.find = string2;
    }

    public void run() throws DataRetrievalException {
        this.assets = null;
        try {
            this.assets = Utils.getAssetStorage().getAssets("Host", this.find, this.sortBy, this.sortOrder);
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
    }

    public String[][] getValues() {
        if (this.assets == null) {
            return null;
        }
        String[][] stringArray = new String[this.assets.length][HostConstants.COLUMN_NUMBER];
        int n = 0;
        while (n < this.assets.length) {
            Asset asset = this.assets[n];
            if (asset == null) {
                this._fillError("Null Asset", stringArray[n]);
            } else if (!(asset instanceof HostAsset)) {
                this._fillError("Asset is not of type HostAsset", stringArray[n]);
            } else {
                HostAsset hostAsset = (HostAsset)asset;
                stringArray[n][0] = hostAsset.getKey();
                stringArray[n][1] = hostAsset.getName();
                stringArray[n][2] = Utils.getVendorModel(hostAsset.getVendor(), hostAsset.getModel());
                stringArray[n][3] = hostAsset.getOS();
            }
            ++n;
        }
        return stringArray;
    }

    private void _fillError(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length > 1) {
            stringArray[1] = string;
        }
    }

    static void main(String[] stringArray) throws Exception {
        HostInventoryCommand hostInventoryCommand = new HostInventoryCommand(null, false, null);
        hostInventoryCommand.run();
        String[][] stringArray2 = hostInventoryCommand.getValues();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("->" + stringArray2[n][0]);
            ++n;
        }
    }
}

