/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.inventory;

import com.sun.netstorage.mgmt.common.datamodel.AssetAggregate;
import com.sun.netstorage.mgmt.common.datamodel.AssetStorage;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.nsmui.common.DataInterpretationException;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.inventory.InventoryConstants;
import com.sun.netstorage.mgmt.nsmui.util.Utils;

public class InventoryCommand {
    AssetStorage pm;
    private AssetAggregate[] assets;
    private String[] sortBy;
    private boolean[] sortOrder;
    private String find = null;

    public InventoryCommand(String string, boolean bl, String string2) {
        if (string == null) {
            this.sortBy = new String[0];
            this.sortOrder = new boolean[0];
        } else {
            this.sortBy = new String[]{string};
            this.sortOrder = new boolean[]{bl};
        }
        this.find = string2;
    }

    public void run() throws DataRetrievalException, DataInterpretationException {
        this.assets = null;
        try {
            this.assets = Utils.getAssetStorage().getAssetAggregate(this.sortBy, this.find, this.sortOrder);
            if (this.assets == null) {
                throw new RuntimeException("Assets is null");
            }
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
        catch (Exception exception) {
            throw new DataInterpretationException("Error with asset's model object", exception);
        }
    }

    public String[][] getValues() {
        if (this.assets == null) {
            return null;
        }
        String[][] stringArray = new String[this.assets.length][InventoryConstants.COLUMN_NUMBER];
        int n = 0;
        while (n < this.assets.length) {
            AssetAggregate assetAggregate = this.assets[n];
            if (assetAggregate == null) {
                stringArray[n][0] = "";
                stringArray[n][1] = "DataModel:Null asset ";
                stringArray[n][2] = "";
            } else {
                stringArray[n][0] = new Integer(assetAggregate.getQuantity()).toString();
                stringArray[n][1] = assetAggregate.getType();
                stringArray[n][2] = assetAggregate.getVendorAndModel();
            }
            ++n;
        }
        return stringArray;
    }

    static void main(String[] stringArray) throws Exception {
        InventoryCommand inventoryCommand = new InventoryCommand(null, false, null);
        inventoryCommand.run();
        String[][] stringArray2 = inventoryCommand.getValues();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("->" + stringArray2[n][0]);
            ++n;
        }
    }
}

