/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.launch;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.admin.AttributeCommand;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.launch.LaunchEFCClient;
import com.sun.netstorage.mgmt.nsmui.launch.LaunchSanBoxManager;
import com.sun.netstorage.mgmt.nsmui.launch.LaunchSanSurfer;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Launch
extends HttpServlet {
    public static final String SADE_TARGET = "sade";
    public static final String SADE_ALARM_JSP = "sadeAlarmJSP";
    public static final String SADE_ASSET_JSP = "sadeAssetJSP";
    public static final String SADE_DEVICE_MANAGER_JSP = "sadeDeviceManagerJSP";
    public static final String SADE_NOTIFICATION_JSP = "sadeNotificationJSP";
    private static final int LAUNCH_QLOGIC_1G_APP = 1;
    private static final int LAUNCH_UNKNOWN_APP = 2;
    private static final int LAUNCH_T3_APP = 3;
    private static final int LAUNCH_SADE = 4;
    private static final int LAUNCH_HITACHI_APP = 5;
    private static final int LAUNCH_QLOGIC_2G_APP = 6;
    private static final int LAUNCH_PORCHE_APP = 7;
    private static final int LAUNCH_MCDATA_APP = 8;
    private static final int LAUNCH_MASERATI_M1_M2_APP = 9;
    private static final int LAUNCH_MASERATI_M3_APP = 10;
    private static final int LAUNCH_MINNOW_APP = 11;
    private static final int LAUNCH_INRANGE_APP = 12;
    private String PAGE_URL = "/nsm/launch";
    public static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.launch.Localization";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private String displayValue;
    private String ipValue;
    private String deviceType;
    private String deviceIP;
    private String ipAddress;
    private String wwn;
    private boolean closed = false;
    private AttributeCommand attributeCommand;

    protected synchronized void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        try {
            string = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.LAUNCH_PAGE));
            if (string == null) {
                return;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.out = httpServletResponse.getWriter();
        this.PAGE_URL = httpServletRequest.getRequestURI();
        if (httpServletRequest.getQueryString() != null) {
            this.PAGE_URL = this.PAGE_URL + "?" + httpServletRequest.getQueryString();
        }
        int n = (string = httpServletRequest.getParameter("vm")) == null ? 2 : this.parseVM(string);
        this.ipAddress = httpServletRequest.getParameter("ip");
        this.wwn = httpServletRequest.getParameter("wwn");
        NSMUIException nSMUIException = null;
        this.closed = false;
        try {
            switch (n) {
                case 2: {
                    if (this.ipAddress == null) {
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "launch_unknown_ip"));
                        break;
                    }
                    if (this.launchOnboardApp(this.ipAddress, null, httpServletResponse)) break;
                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "launch_ip_failed"));
                    break;
                }
                case 1: {
                    if (Utils.isRunningOnSolaris()) {
                        this.launchSanSurfer();
                    }
                    return;
                }
                case 6: {
                    if (Utils.isRunningOnSolaris()) {
                        this.launchSanBoxManager();
                    }
                    return;
                }
                case 3: {
                    if (this.launchT3()) break;
                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "launch_no_url"));
                    break;
                }
                case 4: {
                    if (this.launchSADE()) break;
                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "launch_no_url"));
                    break;
                }
                case 7: {
                    if (this.launchPorche(this.ipAddress)) break;
                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "launch_no_url"));
                    break;
                }
                case 5: {
                    if (this.launchHiCommand() || this.ipAddress != null && this.launchOnboardApp(this.ipAddress, null, httpServletResponse)) break;
                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "launch_no_url"));
                    break;
                }
                case 9: {
                    if (this.launchT4()) break;
                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "launch_no_url"));
                    break;
                }
                case 10: {
                    String string2 = Localization.getString(BUNDLE, "maserati_port");
                    if (this.ipAddress != null && this.launchOnboardApp(this.ipAddress, string2, null, true, httpServletResponse)) break;
                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "launch_ip_failed"));
                    break;
                }
                case 11: {
                    String string3 = Localization.getString(BUNDLE, "minnow_page");
                    if (this.ipAddress != null && this.launchOnboardApp(this.ipAddress, null, string3, false, httpServletResponse)) break;
                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "launch_ip_failed"));
                    break;
                }
                case 8: {
                    this.attributeCommand = new AttributeCommand();
                    this.attributeCommand.run();
                    String string4 = this.attributeCommand.getAttribute("efcm");
                    if (Utils.isRunningOnSolaris() && string4 != null && string4.length() > 0) {
                        this.launchMcDataApp(string4, this.ipAddress);
                        return;
                    }
                    if (this.ipAddress != null && this.launchOnboardApp(this.ipAddress, null, httpServletResponse)) break;
                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "launch_ip_failed"));
                    break;
                }
                case 12: {
                    if (this.launchInrangeApp()) break;
                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "launch_no_url"));
                    break;
                }
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            nSMUIException = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        this.displayMasthead();
        if (nSMUIException != null) {
            this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.LAUNCH_PAGE, nSMUIException));
        }
        this.out.close();
    }

    private void launchSanSurfer() throws ServletException, IOException {
        NSMUIException nSMUIException = null;
        try {
            this.request.setAttribute("LaunchId", (Object)this);
            String string = this.request.getParameter("submitcontrol");
            if (string != null) {
                if (string.equals("launchbutton")) {
                    this.displayValue = this.request.getParameter("displayText");
                    if (this.displayValue.length() == 0) {
                        HTMLTags.addPendingMessage(this.request, "warningMessages", Localization.getString(BUNDLE, "san_no_display_name"));
                    } else {
                        LaunchSanSurfer launchSanSurfer = new LaunchSanSurfer();
                        int n = launchSanSurfer.launchProgram(this.displayValue, 2L);
                        if (n == 0) {
                            HTMLTags.addPendingMessage(this.request, "infoMessages", Localization.getString(BUNDLE, "san_launched"));
                        } else if (n == -1) {
                            HTMLTags.addPendingMessage(this.request, "warningMessages", Localization.getString(BUNDLE, "san_no_package"));
                        } else if (n == -2) {
                            HTMLTags.addPendingMessage(this.request, "warningMessages", Localization.getString(BUNDLE, "san_no_package_script"));
                        } else {
                            HTMLTags.addPendingMessage(this.request, "warningMessages", Localization.getString(BUNDLE, "san_access_denied") + " " + this.displayValue);
                        }
                    }
                } else if (string.equals("cancelbutton")) {
                    this.closeWindow();
                    this.closed = true;
                }
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            nSMUIException = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        if (!this.closed) {
            this.displayMasthead();
            if (nSMUIException != null) {
                this.out.println(HTMLTags.getExceptionBoxTag(this.request, NSMPages.LAUNCH_PAGE, nSMUIException));
            }
            UtilsWeb.include(this.getServletContext(), "/jsp/launch.jsp", this.request, this.response);
        }
    }

    private void launchSanBoxManager() throws ServletException, IOException {
        NSMUIException nSMUIException = null;
        try {
            this.request.setAttribute("LaunchId", (Object)this);
            String string = this.request.getParameter("submitcontrol");
            if (string != null) {
                if (string.equals("launchbutton")) {
                    this.displayValue = this.request.getParameter("displayText");
                    if (this.displayValue.length() == 0) {
                        HTMLTags.addPendingMessage(this.request, "warningMessages", Localization.getString(BUNDLE, "san2_no_display_name"));
                    } else {
                        LaunchSanBoxManager launchSanBoxManager = new LaunchSanBoxManager();
                        int n = launchSanBoxManager.launchProgram(this.displayValue, 2L);
                        if (n == 0) {
                            HTMLTags.addPendingMessage(this.request, "infoMessages", Localization.getString(BUNDLE, "san2_launched"));
                        } else if (n == -1) {
                            HTMLTags.addPendingMessage(this.request, "warningMessages", Localization.getString(BUNDLE, "san2_no_package"));
                        } else if (n == -2) {
                            HTMLTags.addPendingMessage(this.request, "warningMessages", Localization.getString(BUNDLE, "san2_no_package_script"));
                        } else {
                            HTMLTags.addPendingMessage(this.request, "warningMessages", Localization.getString(BUNDLE, "san2_access_denied") + " " + this.displayValue);
                        }
                    }
                } else if (string.equals("cancelbutton")) {
                    this.closeWindow();
                    this.closed = true;
                }
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            nSMUIException = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        if (!this.closed) {
            this.displayMasthead();
            if (nSMUIException != null) {
                this.out.println(HTMLTags.getExceptionBoxTag(this.request, NSMPages.LAUNCH_PAGE, nSMUIException));
            }
            UtilsWeb.include(this.getServletContext(), "/jsp/launch.jsp", this.request, this.response);
        }
    }

    private void launchMcDataApp(String string, String string2) throws ServletException, IOException {
        NSMUIException nSMUIException = null;
        try {
            this.request.setAttribute("LaunchId", (Object)this);
            String string3 = this.request.getParameter("submitcontrol");
            if (string3 != null) {
                if (string3.equals("launchbutton")) {
                    this.displayValue = this.request.getParameter("displayText");
                    if (this.displayValue.length() == 0) {
                        HTMLTags.addPendingMessage(this.request, "warningMessages", Localization.getString(BUNDLE, "efcm_no_display_name"));
                    } else {
                        LaunchEFCClient launchEFCClient = new LaunchEFCClient(string, string2);
                        int n = launchEFCClient.launchProgram(this.displayValue, 2L);
                        if (n == 0) {
                            HTMLTags.addPendingMessage(this.request, "infoMessages", Localization.getString(BUNDLE, "efcm_launched"));
                        } else if (n == -1) {
                            HTMLTags.addPendingMessage(this.request, "warningMessages", Localization.getString(BUNDLE, "efcm_no_package"));
                        } else if (n == -2) {
                            HTMLTags.addPendingMessage(this.request, "warningMessages", Localization.getString(BUNDLE, "efcm_no_package_script"));
                        } else {
                            HTMLTags.addPendingMessage(this.request, "warningMessages", Localization.getString(BUNDLE, "efcm_access_denied") + " " + this.displayValue);
                        }
                    }
                } else if (string3.equals("cancelbutton")) {
                    this.closeWindow();
                    this.closed = true;
                }
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            nSMUIException = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        if (!this.closed) {
            this.displayMasthead();
            if (nSMUIException != null) {
                this.out.println(HTMLTags.getExceptionBoxTag(this.request, NSMPages.LAUNCH_PAGE, nSMUIException));
            }
            UtilsWeb.include(this.getServletContext(), "/jsp/launch.jsp", this.request, this.response);
        }
    }

    private boolean launchT3() throws NSMUIException, ServletException, IOException {
        boolean bl = true;
        this.attributeCommand = new AttributeCommand();
        this.attributeCommand.run();
        String string = this.attributeCommand.getAttribute("t3management");
        if (string == null || string.equals("")) {
            bl = false;
        } else if (string.equals("sscs")) {
            bl = this.launchSSCS();
        } else {
            String string2 = this.attributeCommand.getAttribute(string);
            if (string2 == null || string2.equals("")) {
                bl = false;
            } else {
                UtilsWeb.redirect(string2, this.response);
            }
        }
        return bl;
    }

    private boolean launchT4() throws NSMUIException, ServletException, IOException {
        boolean bl = true;
        this.attributeCommand = new AttributeCommand();
        this.attributeCommand.run();
        String string = this.attributeCommand.getAttribute("t4management");
        if (string == null || string.equals("")) {
            bl = false;
        } else if (string.equals("sscs")) {
            bl = this.launchSSCS();
        } else {
            String string2 = Localization.getString(BUNDLE, "maserati_port");
            bl = this.ipAddress == null ? false : this.launchOnboardApp(this.ipAddress, string2, null, true, this.response);
        }
        return bl;
    }

    private boolean launchSSCS() throws NSMUIException, ServletException, IOException {
        boolean bl = true;
        this.attributeCommand = new AttributeCommand();
        this.attributeCommand.run();
        String string = this.attributeCommand.getAttribute("sscs");
        if (string == null || string.equals("")) {
            bl = false;
        } else {
            if (string.endsWith("/")) {
                string = string + "dm";
            }
            if (!string.endsWith("/dm")) {
                string = string + "/dm";
            }
            String string2 = this.ipAddress != null && this.ipAddress.length() > 0 ? this.ipAddress : this.wwn;
            string = string + "?FAMILY=asset&CMD=info&ID=" + string2;
            UtilsWeb.redirect(string, this.response);
        }
        return bl;
    }

    private boolean launchInrangeApp() throws NSMUIException, ServletException, IOException {
        boolean bl = true;
        this.attributeCommand = new AttributeCommand();
        this.attributeCommand.run();
        String string = this.attributeCommand.getAttribute("inrange");
        if (string == null || string.equals("")) {
            bl = false;
        } else {
            UtilsWeb.redirect(string, this.response);
        }
        return bl;
    }

    private boolean launchHiCommand() throws NSMUIException, ServletException, IOException {
        boolean bl = true;
        this.attributeCommand = new AttributeCommand();
        this.attributeCommand.run();
        String string = this.attributeCommand.getAttribute("hicommand");
        if (string == null || string.equals("")) {
            bl = false;
        } else {
            UtilsWeb.redirect(string, this.response);
        }
        return bl;
    }

    private boolean launchSADE() throws NSMUIException, ServletException, IOException {
        boolean bl = true;
        this.attributeCommand = new AttributeCommand();
        this.attributeCommand.run();
        String string = this.attributeCommand.getAttribute(SADE_TARGET);
        if (string == null || string.equals("")) {
            bl = false;
        } else {
            UtilsWeb.redirect(string, this.response);
        }
        return bl;
    }

    private boolean launchPorche(String string) throws NSMUIException, ServletException, IOException {
        boolean bl = true;
        this.attributeCommand = new AttributeCommand();
        this.attributeCommand.run();
        String string2 = this.attributeCommand.getAttribute(SADE_TARGET);
        if (string2 == null || string2.equals("")) {
            bl = false;
        } else {
            string2 = string2 + Localization.getString(BUNDLE, SADE_DEVICE_MANAGER_JSP);
            string2 = HTMLTags.modifyURLParameter(string2, Localization.getString(BUNDLE, "sadeAssetParam"), string);
            UtilsWeb.redirect(string2, this.response);
        }
        return bl;
    }

    private boolean launchOnboardApp(String string, String string2, HttpServletResponse httpServletResponse) throws ServletException {
        return this.launchOnboardApp(string, string2, null, false, httpServletResponse);
    }

    private boolean launchOnboardApp(String string, String string2, String string3, boolean bl, HttpServletResponse httpServletResponse) throws ServletException {
        StringBuffer stringBuffer = new StringBuffer(bl ? "https://" : "http://");
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append(':');
            stringBuffer.append(string2);
        }
        stringBuffer.append('/');
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        String string4 = stringBuffer.toString();
        try {
            new URL(string4).openConnection();
            UtilsWeb.redirect(string4, httpServletResponse);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).printMasthead(this.request, this.response, NSMPages.LAUNCH_PAGE);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.LAUNCH_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    private void closeWindow() {
        this.out.println("<HTML><SCRIPT LANGUAGE=\"JavaScript=\">");
        this.out.println("<!--");
        this.out.println("function close() { self.close(); }");
        this.out.println("//--> </SCRIPT>");
        this.out.println("<BODY onLoad=close()></HTML>");
        this.out.close();
    }

    private int parseVM(String string) {
        int n = 0;
        if (string.startsWith(Localization.getString(BUNDLE, "qlogic_vm"))) {
            n = 1;
        } else if (string.startsWith(Localization.getString(BUNDLE, "qlogic2_vm"))) {
            n = 6;
        } else if (string.endsWith(Localization.getString(BUNDLE, "t3_vm"))) {
            n = 3;
        } else if (string.equals(Localization.getString(BUNDLE, "sade_vm"))) {
            n = 4;
        } else if (string.startsWith(Localization.getString(BUNDLE, "hitachi_vm"))) {
            n = 5;
        } else if (string.startsWith(Localization.getString(BUNDLE, "porche_6900_vm"))) {
            n = 7;
        } else if (string.startsWith(Localization.getString(BUNDLE, "porche_3900_vm"))) {
            n = 7;
        } else if (string.startsWith(Localization.getString(BUNDLE, "mcdata_vm"))) {
            n = 8;
        } else if (string.endsWith(Localization.getString(BUNDLE, "maserati_m1_m2_vm"))) {
            n = 9;
        } else if (string.endsWith(Localization.getString(BUNDLE, "maserati_m3_vm"))) {
            n = 10;
        } else if (string.endsWith(Localization.getString(BUNDLE, "minnow_vm"))) {
            n = 11;
        } else if (string.startsWith(Localization.getString(BUNDLE, "inrange_vm"))) {
            n = 12;
        }
        String string2 = string.toLowerCase();
        if (n == 0) {
            n = string2.indexOf("qlogic") != -1 ? 1 : (string2.indexOf("sun") != -1 && string2.indexOf("t3") != -1 ? 3 : (string2.indexOf(SADE_TARGET) != -1 ? 4 : (string2.indexOf("hitachi") != -1 || string2.indexOf("hds") != -1 ? 5 : 2)));
        }
        return n;
    }

    public String getDescriptionText() {
        return HTMLTags.getCustomTag(BUNDLE, "description_text");
    }

    public String getDisplayLabel() {
        return HTMLTags.getCustomTag(BUNDLE, "display_label");
    }

    public String getDisplayText() {
        return HTMLTags.getInputFieldTag("displayText", this.displayValue, 50, 100);
    }

    public String getLaunchButton() {
        return HTMLTags.getSubmitButtonTag("launchbutton", Localization.getString(BUNDLE, "launch_label"));
    }

    public String getCancelButton() {
        return HTMLTags.getSubmitButtonTag("cancelbutton", Localization.getString(BUNDLE, "cancel_label"));
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "This is the Application Launch page.";
    }
}

