/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.login;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.admin.AttributeCommand;
import com.sun.netstorage.mgmt.nsmui.common.Configuration;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.common.SystemAddresses;
import com.sun.netstorage.mgmt.nsmui.login.LoginCommand;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class Login
extends HttpServlet {
    public static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.login.Localization";
    public static String USER_NAME = "userName";
    public static String PASSWORD = "password";
    public static String LOGOUT = "logout";

    public void init() throws ServletException {
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        try {
            boolean bl = false;
            Object var4_5 = null;
            HttpSession httpSession = httpServletRequest.getSession(true);
            String string = (String)httpSession.getAttribute("forward");
            if (string == null) {
                string = SystemAddresses.DEFAULT_START_PAGE;
            }
            String string2 = httpServletRequest.getParameter(USER_NAME);
            String string3 = httpServletRequest.getParameter(PASSWORD);
            if (string2 != null) {
                bl = this.checkCredentials(string2, string3, httpServletRequest, httpServletResponse);
            }
            if (bl) {
                httpSession.removeAttribute("forward");
                UtilsWeb.redirect(string, httpServletResponse);
            } else {
                this.requestLogin(null, httpServletRequest, httpServletResponse);
            }
        }
        catch (Throwable throwable) {
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.print(HTMLTags.getExceptionBoxTag(httpServletRequest, null, throwable));
            printWriter.close();
        }
    }

    private void requestLogin(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        UtilsWeb.header(httpServletResponse);
        httpServletRequest.getSession(true).removeAttribute("role");
        if (string != null) {
            HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", string);
        }
        UtilsWeb.include(this.getServletContext(), "/jsp/login.jsp", httpServletRequest, httpServletResponse);
    }

    private boolean checkCredentials(String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws NSMUIException, ServletException, IOException {
        LoginCommand loginCommand = new LoginCommand(Configuration.getProperty("PAM_VERIFIER_DIR"));
        loginCommand.setName(string);
        loginCommand.setPassword(string2);
        loginCommand.run();
        String string3 = loginCommand.getRole();
        if (loginCommand.getMessage() != null) {
            HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", loginCommand.getMessage());
        }
        if (string3 == null) {
            return false;
        }
        Security.getSecurity().setAuthorization(string3, httpServletRequest);
        return true;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        String string = httpServletRequest.getParameter(LOGOUT) != null ? Localization.getString(BUNDLE, "message_loggedout") : null;
        this.requestLogin(string, httpServletRequest, httpServletResponse);
    }

    public void destroy() {
    }

    public static String getContactEmailURL() {
        try {
            String string = new AttributeCommand().getAttribute("contactemail");
            return string != null ? string : "";
        }
        catch (Throwable throwable) {
            return Localization.getString(BUNDLE, "email_not_available");
        }
    }
}

