/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.notification;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.notification.EmailBean;
import com.sun.netstorage.mgmt.nsmui.notification.EmailCommand;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EmailDel
extends HttpServlet {
    private static final String EMAIL_DEL_FORM_NAME = "emaildelform";
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.notification.Localization";
    private static final String ID_FIELD_NAME = "idHidden";
    private static final String SEVERITY_MENU_NAME = "severityselect";
    private static final String MEDIUM_MENU_NAME = "mediumselect";
    private static final String PERIOD_MENU_NAME = "timeselect";
    private static final String LOCALE_MENU_NAME = "localeselect";
    private static final String ADDRESS_TEXT_NAME = "addressText";
    private static final String TIME_TEXT_NAME = "timeText";
    private static final String ID_NAME = "id";
    private static final String DELETE_BUTTON_NAME = "deletebutton";
    private static final String SEVERITY_MENU_LABEL = "severity_label";
    private static final String MEDIUM_MENU_LABEL = "medium_label";
    private static final String ADDRESS_MENU_LABEL = "address_label";
    private static final String TIME_MENU_LABEL = "time_label";
    private static final String LOCALE_MENU_LABEL = "locale_label";
    private static final String DELETE_BUTTON_LABEL = "delete_label";
    private static final int NO_MESSAGE = 0;
    private static final int INFO_MESSAGE = 1;
    private static final int WARNING_MESSAGE = 2;
    private static final int ERROR_MESSAGE = 3;
    private EmailCommand emailCommand = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private String severityValue;
    private String mediumValue;
    private String periodValue;
    private String localeValue;
    private EmailBean eb;
    private String idValue;

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.out = httpServletResponse.getWriter();
        try {
            object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.EMAIL_DEL_PAGE));
            if (object == null || !((String)object).equalsIgnoreCase("Admin")) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "not_authorized"));
                this.displayMasthead();
                return;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        object = null;
        try {
            UtilsWeb.noCacheHeader(httpServletResponse);
            this.idValue = httpServletRequest.getParameter(ID_NAME);
            if (this.idValue == null) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "del_email_msg_no_id"));
                UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_EMAIL_PAGE), httpServletResponse);
            } else {
                String string = httpServletRequest.getParameter("submitcontrol");
                if (string != null) {
                    if (string.equals(DELETE_BUTTON_NAME)) {
                        this.emailCommand.deleteContract(this.idValue);
                        UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_EMAIL_PAGE), httpServletResponse);
                    } else if (string.equals("cancelbutton")) {
                        UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_EMAIL_PAGE), httpServletResponse);
                    }
                } else {
                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "del_email_msg_are_you_sure"));
                    this.emailCommand = new EmailCommand();
                    this.emailCommand.run();
                    httpServletRequest.setAttribute("EmailDelId", (Object)this.eb);
                    Hashtable hashtable = this.emailCommand.getContract(this.idValue);
                    if (hashtable == null) {
                        HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "del_email_msg_no_contract"));
                        this.displayMasthead();
                    } else {
                        this.setupInitialValues(hashtable);
                        this.displayMasthead();
                        UtilsWeb.include(this.getServletContext(), "/jsp/emaildel.jsp", httpServletRequest, httpServletResponse);
                    }
                }
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            object = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        if (object != null) {
            this.displayMasthead();
            this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.EMAIL_DEL_PAGE, (Throwable)object));
            this.out.flush();
        }
    }

    public void setupInitialValues(Hashtable hashtable) {
        this.eb.setId((String)hashtable.get("ID"));
        this.eb.setSeverity(Utils.mapSeverityToToken((String)hashtable.get("Criteria")));
        this.eb.setMedium(((String)hashtable.get("IsPager")).equals("yes") ? "pager" : "email");
        this.eb.setLocale(((String)hashtable.get("Locale")).toLowerCase());
        this.eb.setAddress((String)hashtable.get("To"));
        String[] stringArray = Utils.getTimeValue((String)hashtable.get("NotificationInterval"));
        this.eb.setTime(stringArray[0]);
        this.eb.setPeriod(stringArray[1]);
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Administration", "Administration", "General", NSMPages.getPageHelp(NSMPages.EMAIL_DEL_PAGE), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.EMAIL_DEL_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.eb = new EmailBean(EMAIL_DEL_FORM_NAME);
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "This is the Delete an Email Contract page.";
    }
}

