/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.notification;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.notification.SNMPCommand;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.SeverityColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SNMP
extends HttpServlet {
    private static final String PAGE_URL = "/nsm/snmp";
    private SNMPCommand snmpCommand = null;
    private static final int DEFAULT_SORT_COL = -2;
    private static final TableColumn[] COLUMNS = new TableColumn[5];
    private static final int ID_COLUMN = 0;
    private static final int LEVEL_COLUMN = 1;
    private static final int HOST_COLUMN = 2;
    private static final int PORT_COLUMN = 3;
    private static final int LOCALE_COLUMN = 4;
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.notification.Localization";
    private static final String CANCEL_BUTTON_LABEL = "cancel_label";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private String[] buttonItems = new String[]{"snmp_action_menu_item1", "snmp_action_menu_item2", "snmp_action_menu_item3"};
    private boolean[] buttonsOff = new boolean[]{true, false, false};
    private boolean[] buttonsOn = new boolean[]{true, true, true};
    private String tableTitle;
    private String theTable;

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.out = httpServletResponse.getWriter();
        try {
            object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.ADMIN_SNMP_PAGE));
            if (object == null || !((String)object).equalsIgnoreCase("Admin")) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "not_authorized"));
                this.displayMasthead();
                return;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        object = null;
        boolean bl = false;
        try {
            UtilsWeb.noCacheHeader(httpServletResponse);
            String string = httpServletRequest.getParameter("submitcontrol");
            if (string != null) {
                String string2 = httpServletRequest.getParameter("id");
                if (string.equals("snmp_action_menu_item1")) {
                    UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.SNMP_ADD_PAGE), httpServletResponse);
                    bl = true;
                } else if (string.equals("snmp_action_menu_item2")) {
                    if (string2 != null) {
                        UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.SNMP_DEL_PAGE) + "?id=" + httpServletRequest.getParameter("id"), httpServletResponse);
                        bl = true;
                    } else {
                        HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "snmp_msg_no_id"));
                    }
                } else if (string.equals("snmp_action_menu_item3")) {
                    if (string2 != null) {
                        UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.SNMP_MOD_PAGE) + "?id=" + httpServletRequest.getParameter("id"), httpServletResponse);
                        bl = true;
                    } else {
                        HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "snmp_msg_no_id"));
                    }
                }
            }
            this.snmpCommand = new SNMPCommand();
            this.snmpCommand.run();
            httpServletRequest.setAttribute("SNMPId", (Object)this);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            object = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        if (!bl) {
            this.displayMasthead();
            if (object != null) {
                this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.ADMIN_SNMP_PAGE, (Throwable)object));
                this.out.flush();
            } else {
                this.buildTable();
                UtilsWeb.include(this.getServletContext(), "/jsp/snmp.jsp", httpServletRequest, httpServletResponse);
            }
        }
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Administration", "Administration", "General", NSMPages.getPageHelp(NSMPages.ADMIN_SNMP_PAGE), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.ADMIN_SNMP_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    public void buildTable() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = this.snmpCommand.count();
        HTMLTags.TableInfo tableInfo = HTMLTags.getTableInfo(this.request, -2, n);
        int n2 = tableInfo.sortColumn;
        int n3 = tableInfo.firstRow;
        int n4 = tableInfo.pageSize;
        String[][] stringArray = this.snmpCommand.getContracts();
        int n5 = 0;
        while (n5 < this.snmpCommand.count()) {
            stringArray[n5][4] = Localization.getString(BUNDLE, stringArray[n5][4].toLowerCase());
            ++n5;
        }
        int n6 = Math.abs(tableInfo.sortColumn) - 1;
        if (n6 == 1) {
            Arrays.sort(stringArray, new SeverityColumnComparator(n2));
        } else {
            Arrays.sort(stringArray, new SmartColumnComparator(n2));
        }
        int n7 = Math.min(n4, n - n3);
        String[][] stringArray2 = new String[n7][];
        System.arraycopy(stringArray, n3, stringArray2, 0, n7);
        int n8 = 0;
        while (n8 < n7) {
            stringArray2[n8][1] = this.getLevel(stringArray2[n8][1]);
            ++n8;
        }
        int n9 = 0;
        while (n9 < n7) {
            stringArray2[n9][0] = "<input type=radio name=id value=" + stringArray2[n9][0] + ">";
            ++n9;
        }
        this.tableTitle = n <= n4 ? HTMLTags.getTableTitleTag(Localization.getString(BUNDLE, "snmp_table_title")) : HTMLTags.getTableTitleTag(Localization.getString(BUNDLE, "snmp_table_title"), n3, n, n4);
        if (n == 0) {
            stringBuffer2.append(HTMLTags.getActionButtonsTag(BUNDLE, "actionMenuTitle", this.buttonItems, this.buttonsOff));
        } else {
            stringBuffer2.append(HTMLTags.getActionButtonsTag(BUNDLE, "actionMenuTitle", this.buttonItems, this.buttonsOn));
        }
        stringBuffer2.append(HTMLTags.getTableTag(PAGE_URL, COLUMNS, stringArray2, n2, n3, n, n4));
        this.theTable = stringBuffer2.toString();
    }

    public String getAlarmLevelLabel() {
        return HTMLTags.getCustomTag(BUNDLE, "alarm_level_header_label");
    }

    public String getSNMPTableText() {
        return HTMLTags.getCustomTag(BUNDLE, "snmp_table_title");
    }

    public String getSNMPTableTitle() {
        return this.tableTitle;
    }

    public String getSNMPTable() {
        return this.theTable;
    }

    public String getSaveButton() {
        return HTMLTags.getSubmitButtonTag("savebutton", Localization.getString(BUNDLE, "save_label"));
    }

    public String getCancelButton() {
        return HTMLTags.getLinkButtonTag(NSMPages.getPageURL(NSMPages.ADMIN_PAGE), Localization.getString(BUNDLE, CANCEL_BUTTON_LABEL));
    }

    private String getLevel(String string) {
        String string2 = Utils.mapSeverityToToken(string);
        return "<IMG src=\"/nsm/images/icons/" + Localization.getString(BUNDLE, "level_icon_14_" + string2) + "\" width=\"14\" height=\"14\" border=\"0\" alt=\"" + Localization.getString(BUNDLE, "level_icon_text_" + string2) + "\"> " + Localization.getString(BUNDLE, string2);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (COLUMNS[0] == null) {
            SNMP.COLUMNS[0] = new TableColumn("    ", false, "\"left\"");
            SNMP.COLUMNS[1] = new TableColumn(Localization.getString(BUNDLE, "snmp_table_title_level"), true, "\"left\"");
            SNMP.COLUMNS[2] = new TableColumn(Localization.getString(BUNDLE, "snmp_table_title_hostname"), true, "\"left\"");
            SNMP.COLUMNS[3] = new TableColumn(Localization.getString(BUNDLE, "snmp_table_title_port"), true, "\"right\"");
            SNMP.COLUMNS[4] = new TableColumn(Localization.getString(BUNDLE, "snmp_table_title_locale"), true, "\"left\"");
        }
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "This is the main SNMP Notification page.";
    }
}

