/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.notification;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.notification.SNMPBean;
import com.sun.netstorage.mgmt.nsmui.notification.SNMPCommand;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SNMPDel
extends HttpServlet {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.notification.Localization";
    private SNMPCommand snmpCommand = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private String severityValue;
    private String mediumValue;
    private String periodValue;
    private String localeValue;
    private SNMPBean sb;
    private String idValue;

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.out = httpServletResponse.getWriter();
        try {
            object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.SNMP_DEL_PAGE));
            if (object == null || !((String)object).equalsIgnoreCase("Admin")) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "not_authorized"));
                this.displayMasthead();
                return;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        object = null;
        try {
            UtilsWeb.noCacheHeader(httpServletResponse);
            this.idValue = httpServletRequest.getParameter("id");
            if (this.idValue == null) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "del_snmp_msg_no_id"));
                UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_SNMP_PAGE), httpServletResponse);
            } else {
                String string = httpServletRequest.getParameter("submitcontrol");
                if (string != null) {
                    if (string.equals("deletebutton")) {
                        this.snmpCommand.deleteContract(this.idValue);
                        UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_SNMP_PAGE), httpServletResponse);
                    } else if (string.equals("cancelbutton")) {
                        UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_SNMP_PAGE), httpServletResponse);
                    }
                } else {
                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "del_snmp_msg_are_you_sure"));
                    this.snmpCommand = new SNMPCommand();
                    this.snmpCommand.run();
                    httpServletRequest.setAttribute("SNMPBeanId", (Object)this.sb);
                    Hashtable hashtable = this.snmpCommand.getContract(this.idValue);
                    if (hashtable == null) {
                        HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "del_snmp_msg_no_contract"));
                        this.displayMasthead();
                    } else {
                        this.setupInitialValues(hashtable);
                        this.displayMasthead();
                        UtilsWeb.include(this.getServletContext(), "/jsp/snmpdel.jsp", httpServletRequest, httpServletResponse);
                    }
                }
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            object = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        if (object != null) {
            this.displayMasthead();
            this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.SNMP_DEL_PAGE, (Throwable)object));
            this.out.flush();
        }
    }

    public void setupInitialValues(Hashtable hashtable) {
        this.sb.setId((String)hashtable.get("ID"));
        this.sb.setSeverity(Utils.mapSeverityToToken((String)hashtable.get("Criteria")));
        this.sb.setHostname((String)hashtable.get("Hostname"));
        this.sb.setLocale(((String)hashtable.get("Locale")).toLowerCase());
        this.sb.setPort((String)hashtable.get("Port"));
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Administration", "Administration", "General", NSMPages.getPageHelp(NSMPages.SNMP_DEL_PAGE), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.SNMP_DEL_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.sb = new SNMPBean("snmpdelform");
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "This is the Delete an SNMP Contract page.";
    }
}

