/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.storage;

import com.sun.netstorage.mgmt.common.datamodel.Asset;
import com.sun.netstorage.mgmt.common.datamodel.AssetStorage;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.component.model.api.gui.DeviceNode;
import com.sun.netstorage.mgmt.component.model.api.gui.LUN;
import com.sun.netstorage.mgmt.component.model.api.gui.StorageAsset;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.storage.StorageConstants;
import com.sun.netstorage.mgmt.nsmui.util.Utils;

public class LunCommand {
    private static final boolean debug = false;
    AssetStorage pm;
    StorageAsset device;
    private LUN[] assets;
    private final String deviceId;
    private String[] sortBy;
    private boolean[] sortOrder;
    private String find = null;

    public LunCommand(String string, String string2, boolean bl, String string3) {
        this.deviceId = string;
        if (string2 == null) {
            this.sortBy = new String[0];
            this.sortOrder = new boolean[0];
        } else {
            this.sortBy = new String[]{string2};
            this.sortOrder = new boolean[]{bl};
        }
        this.find = string3;
    }

    public void removeDevice(String string) {
    }

    public void run() throws DataRetrievalException {
        this.assets = null;
        try {
            Asset asset = Utils.getAssetStorage().getAsset(this.deviceId);
            if (asset != null) {
                this.device = (StorageAsset)Utils.getAssetStorage().getAsset(this.deviceId);
                this.assets = this.device.getLUNs(this.sortBy, this.sortOrder);
            }
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
    }

    public String getDeviceKey() {
        return this.device == null ? null : this.device.getKey();
    }

    public String getDeviceName() {
        return this.device == null ? null : this.device.getName();
    }

    public String[][] getValues() throws PersistenceException {
        if (this.assets == null || this.assets.length == 0) {
            return null;
        }
        String[][] stringArray = new String[this.assets.length][StorageConstants.LUNS_COLUMN_NUMBER];
        int n = 0;
        while (n < this.assets.length) {
            LUN lUN = this.assets[n];
            if (lUN == null) {
                this._fillError("Null Asset", stringArray[n]);
            } else {
                int n2 = 0;
                stringArray[n][n2++] = lUN.getNumber();
                stringArray[n][n2++] = lUN.getCapacity();
                DeviceNode[] deviceNodeArray = lUN.getDeviceNodes(null, null);
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                int n3 = 0;
                while (n3 < deviceNodeArray.length) {
                    String string;
                    String string2;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" | ");
                    }
                    stringBuffer.append((string2 = deviceNodeArray[n3].getDeviceId()) == null ? "" : string2);
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(" | ");
                    }
                    stringBuffer2.append((string = deviceNodeArray[n3].getPath()) == null ? "" : string);
                    ++n3;
                }
                stringArray[n][n2++] = stringBuffer.toString();
                stringArray[n][n2++] = stringBuffer2.toString();
            }
            ++n;
        }
        return stringArray;
    }

    private void _fillError(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length > 1) {
            stringArray[1] = string;
        }
    }

    static void main(String[] stringArray) throws Exception {
        LunCommand lunCommand = new LunCommand("", null, false, null);
        lunCommand.run();
        String[][] stringArray2 = lunCommand.getValues();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("->" + stringArray2[n][0]);
            ++n;
        }
    }
}

