/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.switches;

import com.sun.netstorage.mgmt.common.datamodel.AssetStorage;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.component.model.api.gui.SwitchAsset;
import com.sun.netstorage.mgmt.component.model.api.gui.SwitchAssetPort;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.switches.SwitchConstants;
import com.sun.netstorage.mgmt.nsmui.util.Utils;

public class SwitchPortsCommand {
    private static final boolean debug = false;
    AssetStorage pm;
    private SwitchAsset asset;
    private SwitchAssetPort[] ports;
    private String key;
    private String[] sortBy;
    private boolean[] sortOrder;
    private String find = null;

    public SwitchPortsCommand(String string, boolean bl, String string2) {
        if (string == null) {
            this.sortBy = new String[0];
            this.sortOrder = new boolean[0];
        } else {
            this.sortBy = new String[]{string};
            this.sortOrder = new boolean[]{bl};
        }
        this.find = string2;
    }

    public void run() throws DataRetrievalException {
        this.ports = null;
        try {
            this.asset = (SwitchAsset)Utils.getAssetStorage().getAsset(this.find);
            if (this.asset == null) {
                return;
            }
            this.ports = this.asset.getPorts(this.sortBy, this.sortOrder);
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
    }

    public String _getSwitchKey() {
        return this.asset == null ? null : this.asset.getKey();
    }

    public String getSwitchName() {
        return this.asset == null ? null : this.asset.getName();
    }

    public String[][] getValues() throws PersistenceException {
        if (this.ports == null || this.ports.length == 0) {
            return null;
        }
        String[][] stringArray = new String[this.ports.length][SwitchConstants.PORTS_COLUMN_NUMBER];
        int n = 0;
        while (n < this.ports.length) {
            SwitchAssetPort switchAssetPort = this.ports[n];
            int n2 = 0;
            stringArray[n][n2++] = switchAssetPort.getKey();
            stringArray[n][n2++] = switchAssetPort.getState();
            stringArray[n][n2++] = switchAssetPort.getWWN();
            stringArray[n][n2++] = new Integer(switchAssetPort.getPortNumber()).toString();
            stringArray[n][n2++] = switchAssetPort.getPortType();
            stringArray[n][n2++] = switchAssetPort.getGBICType();
            ++n;
        }
        return stringArray;
    }

    private void _fillError(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length > 1) {
            stringArray[1] = string;
        }
    }

    static void main(String[] stringArray) throws Exception {
        SwitchPortsCommand switchPortsCommand = new SwitchPortsCommand(null, false, null);
        switchPortsCommand.run();
        String[][] stringArray2 = switchPortsCommand.getValues();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("->" + stringArray2[n][0]);
            ++n;
        }
    }
}

