/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.topology;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyBaseServlet;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyCommand;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyGraphModel;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.SmartComparator;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import com.sun.netstorage.mgmt.services.topology.TopologyServiceImpl;
import com.sun.netstorage.mgmt.services.topology.Zone;
import com.sun.web.ui.model.CCTopologyNode;
import com.sun.web.ui.servlet.topology.CCTopologyServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ConnectivityServlet
extends TopologyBaseServlet {
    private TopologyCommand topoCommand;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.topoCommand = new TopologyCommand();
    }

    protected PrintWriter writePageStart(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2, String string3) throws IOException, ServletException {
        String string4 = this.getParentPageName(httpServletRequest);
        HTMLTags.addTimestamp(httpServletRequest, "start");
        Masthead.getMasthead(this.getServletContext()).print(NSMPages.getPageTitle(NSMPages.CONNECTIVITY_PAGE), NSMPages.getPageSection(string4), NSMPages.getPageSubsection(string4), NSMPages.getPageHelp(NSMPages.CONNECTIVITY_PAGE), httpServletRequest, httpServletResponse);
        httpServletResponse.getWriter().flush();
        HTMLTags.addTimestamp(httpServletRequest, "masthead");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println(HTMLTags.getExtendedBreadCrumbTag(httpServletRequest, string4, NSMPages.getPageCrumbName(NSMPages.CONNECTIVITY_PAGE)));
        String string5 = NSMPages.getPageURL(NSMPages.CONNECTIVITY_PAGE);
        String string6 = httpServletRequest.getParameter("stubDB");
        if (string6 != null) {
            string5 = HTMLTags.modifyURLParameter(string5, "stubDB", string6);
        }
        printWriter.println(HTMLTags.getContentStartTags(string5));
        printWriter.println(HTMLTags.getPendingMessagesTag(httpServletRequest));
        printWriter.flush();
        HTMLTags.addTimestamp(httpServletRequest, "breadcrumb");
        printWriter.print("<input type=hidden name=\"");
        printWriter.print("id");
        printWriter.print("\" value=\"");
        printWriter.print(string);
        printWriter.println("\">");
        printWriter.print("<input type=hidden name=\"");
        printWriter.print("returnTo");
        printWriter.print("\" value=\"");
        printWriter.print(string4);
        printWriter.println("\">");
        string5 = HTMLTags.modifyURLParameter(string5, "id", string);
        string5 = HTMLTags.modifyURLParameter(string5, "fabric", string2);
        string5 = HTMLTags.modifyURLParameter(string5, "zone", string3);
        string5 = HTMLTags.modifyURLParameter(string5, "returnTo", string4);
        HTMLTags.setBreadCrumbData(httpServletRequest.getSession(), NSMPages.CONNECTIVITY_PAGE, string5, null);
        return printWriter;
    }

    private String getParentPageName(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("returnTo");
        return string != null ? string : NSMPages.FABRIC_INVENTORY_PAGE;
    }

    protected void writeConnectivityPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        PrintWriter printWriter;
        block30: {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = httpServletRequest.getParameter("id");
            if (string7 != null) {
                string6 = TopologyCommand.getAssetName(string7, "Host");
                if (string6 != null) {
                    string5 = NSMPages.HOST_DETAILS_PAGE;
                    string2 = string7;
                }
                if (string6 == null) {
                    string6 = TopologyCommand.getAssetName(string7, "HBA");
                    if (string6 != null) {
                        string5 = NSMPages.HBA_DETAILS_PAGE;
                        string = string7;
                    }
                }
                if (string6 == null) {
                    string6 = TopologyCommand.getAssetName(string7, "Storage");
                    if (string6 != null) {
                        string5 = NSMPages.STORAGE_DETAILS_PAGE;
                        string4 = string7;
                    }
                }
                if (string6 == null) {
                    string6 = TopologyCommand.getAssetName(string7, "Switch");
                    if (string6 != null) {
                        string5 = NSMPages.SWITCH_DETAILS_PAGE;
                        string3 = string7;
                    }
                }
            }
            String[] stringArray = this.processZoneMenu(httpServletRequest, httpServletResponse);
            String string8 = stringArray[0];
            String string9 = stringArray[1];
            printWriter = this.writePageStart(httpServletRequest, httpServletResponse, string7, string8, string9);
            printWriter.println(HTMLTags.getTableTitleTag(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "connectivityTitle", string6 == null ? string7 : HTMLTags.getLinkTag(HTMLTags.modifyURLParameter(NSMPages.getPageURL(string5), "id", string7), string6))));
            if (string2 == null && string4 == null && string3 == null && string == null) {
                HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "invalidID", string7));
                this.writePageEnd(httpServletRequest, printWriter);
                return;
            }
            try {
                TopologyGraph topologyGraph;
                TopologyServiceImpl topologyServiceImpl = TopologyServiceImpl.getInstance();
                SanTopology sanTopology = this.getSanTopology(topologyServiceImpl, httpServletRequest);
                if (sanTopology == null) break block30;
                HTMLTags.addTimestamp(httpServletRequest, "get topology from model");
                TSTopologyNode tSTopologyNode = topologyServiceImpl.findNode((Object)string7);
                HTMLTags.addTimestamp(httpServletRequest, "find node in topology");
                FabricTopology fabricTopology = null;
                Zone zone = null;
                if (string9 != null) {
                    TopologyGraph topologyGraph2;
                    if (string8 == null) {
                        topologyGraph2 = sanTopology.getFabrics();
                    } else {
                        FabricTopology[] fabricTopologyArray = new FabricTopology[1];
                        topologyGraph2 = fabricTopologyArray;
                        fabricTopologyArray[0] = sanTopology.getFabric(string8);
                    }
                    topologyGraph = topologyGraph2;
                    int n = 0;
                    while (zone == null && n < ((TopologyGraph)topologyGraph).length) {
                        if (topologyGraph[n] == null) {
                            HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "fabricNotFound"));
                        } else {
                            zone = topologyGraph[n].getZone(string9);
                            if (zone != null) {
                                fabricTopology = topologyGraph[n];
                            }
                        }
                        ++n;
                    }
                }
                if (string8 != null && fabricTopology == null) {
                    fabricTopology = sanTopology.getFabric(string8);
                }
                topologyGraph = sanTopology.getConnectivityGraph(tSTopologyNode, true);
                TopologyGraphModel topologyGraphModel = null;
                if (topologyGraph.getNodeCount() > 0) {
                    topologyGraphModel = new TopologyGraphModel(this.servletContext, topologyGraph, fabricTopology, zone);
                }
                HTMLTags.addTimestamp(httpServletRequest, "get SAN connectivity graph");
                if (string != null) {
                    try {
                        ((CCTopologyNode)topologyGraphModel.getTierNodes(0)[0]).setLabel(string6);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (topologyGraphModel == null) {
                    printWriter.println(HTMLTags.getInfoBoxTag(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "noSANConnectivityFound")));
                } else {
                    String string10;
                    String[] stringArray2 = topologyGraph.getFabricNames();
                    FabricTopology[] fabricTopologyArray = new FabricTopology[stringArray2.length];
                    int n = 0;
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        fabricTopologyArray[n2] = sanTopology.getFabric(stringArray2[n2]);
                        string10 = fabricTopologyArray[n2].getFabricId().getLogicalName();
                        if (string10 != null) {
                            stringArray2[n2] = string10;
                        }
                        n += fabricTopologyArray[n2].getZones().length;
                        ++n2;
                    }
                    Arrays.sort(stringArray2, new SmartComparator());
                    string10 = Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "fabricSeparator");
                    StringBuffer stringBuffer = new StringBuffer();
                    int n3 = 0;
                    while (n3 < stringArray2.length) {
                        if (n3 > 0) {
                            stringBuffer.append(string10);
                        }
                        stringBuffer.append(stringArray2[n3]);
                        ++n3;
                    }
                    String string11 = NSMPages.getPageURL(NSMPages.CONNECTIVITY_DETAIL_PAGE);
                    string11 = HTMLTags.modifyURLParameter(string11, "returnTo", httpServletRequest.getParameter("returnTo"));
                    string11 = HTMLTags.modifyURLParameter(string11, "id", string7);
                    string11 = HTMLTags.modifyURLParameter(string11, "fabric", string8);
                    string11 = HTMLTags.modifyURLParameter(string11, "zone", string9);
                    string11 = HTMLTags.modifyURLParameter(string11, "stubDB", httpServletRequest.getParameter("stubDB"));
                    this.writePathsZoneMenu(printWriter, fabricTopologyArray, string9, string8, string11);
                    printWriter.println(CCTopologyServlet.getTopologyImageTags(httpServletRequest.getSession(), null, topologyGraphModel));
                    printWriter.println("\n<p>\n");
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                printWriter.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.CONNECTIVITY_PAGE, new DataRetrievalException(throwable)));
            }
        }
        this.writePageEnd(httpServletRequest, printWriter);
    }

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!this.performSecurityCheck(httpServletRequest, httpServletResponse)) {
            return;
        }
        this.writeConnectivityPage(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "NSM Connectivity Servlet";
    }
}

