/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.topology;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.topology.DASInventoryCommand;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyBaseServlet;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TopologyServiceImpl;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class DASInventoryServlet
extends TopologyBaseServlet {
    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!this.performSecurityCheck(httpServletRequest, httpServletResponse)) {
            return;
        }
        PrintWriter printWriter = this.writePageStart(httpServletRequest, httpServletResponse, NSMPages.DAS_PAGE, null, null);
        try {
            TopologyServiceImpl topologyServiceImpl = TopologyServiceImpl.getInstance();
            SanTopology sanTopology = this.getSanTopology(topologyServiceImpl, httpServletRequest);
            DASInventoryCommand dASInventoryCommand = new DASInventoryCommand(sanTopology, true);
            dASInventoryCommand.run();
            HTMLTags.addTimestamp(httpServletRequest, "search for DAS");
            int n = dASInventoryCommand.getRowCount();
            HTMLTags.TableInfo tableInfo = HTMLTags.getTableInfo(httpServletRequest, 1, n);
            String[][] stringArray = dASInventoryCommand.getTableData(tableInfo);
            HTMLTags.addTimestamp(httpServletRequest, "get data from command");
            printWriter.println(HTMLTags.getContentSubSectionTags("\"right\""));
            String string = NSMPages.getPageURL(NSMPages.DAS_DETAIL_PAGE);
            String string2 = httpServletRequest.getParameter("stubDB");
            if (string2 != null) {
                string = HTMLTags.modifyURLParameter(string, "stubDB", string2);
            }
            printWriter.println(HTMLTags.getLinkButtonTag(string, Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "dasDetails")));
            printWriter.println(HTMLTags.getContentSubSectionTags("\"left\"", 16));
            printWriter.println(HTMLTags.getTableTitleTag(Localization.getString("com.sun.netstorage.mgmt.nsmui.topology.Localization", "das"), tableInfo.firstRow, n, tableInfo.pageSize));
            printWriter.println(HTMLTags.getTableTag(HTMLTags.createURL(httpServletRequest.getRequestURI(), httpServletRequest.getQueryString()), DASInventoryCommand.getColumns(), stringArray, tableInfo.sortColumn, tableInfo.firstRow, n, tableInfo.pageSize));
            HTMLTags.addTimestamp(httpServletRequest, "write table");
        }
        catch (NSMUIException nSMUIException) {
            printWriter.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.DAS_PAGE, nSMUIException));
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            printWriter.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.DAS_PAGE, new DataRetrievalException(throwable)));
        }
        this.writePageEnd(httpServletRequest, printWriter);
    }

    public String getServletInfo() {
        return "NSM DAS Inventory Servlet";
    }
}

